/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.FilterPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CFilterPanel;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterFactory;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterFieldListener;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterPanelListener;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilteredTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Help.IHelpInformation;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class CTablePanel<T>
extends CAbstractNodeComponent {
    private static final long serialVersionUID = 159443513599950639L;
    private final IFilteredTable<T> m_table;
    private final CFilterPanel<T> m_filterPanel;
    private final TitledBorder m_titledBorder;
    private final InternalFilterPanelListener m_filterListener = new InternalFilterPanelListener();
    private final ListenerProvider<IFilterFieldListener> m_listeners = new ListenerProvider();
    private final IFilterFactory<T> m_filterFactory;

    public CTablePanel(IFilteredTable<T> table, IFilterFactory<T> filterFactory, IHelpInformation filterHelp) {
        super(new BorderLayout());
        Preconditions.checkNotNull(table, "IE01841: Table argument can not be null");
        this.m_table = table;
        this.m_filterFactory = filterFactory;
        if (filterFactory == null) {
            this.m_filterPanel = null;
        } else {
            this.m_filterPanel = new CFilterPanel<T>(filterFactory, filterHelp);
            this.add(this.m_filterPanel, "North");
            this.m_filterPanel.addListener(this.m_filterListener);
        }
        this.m_titledBorder = new TitledBorder("");
        this.setBorder(this.m_titledBorder);
        this.add((Component)new JScrollPane(this.m_table.self()), "Center");
    }

    protected void disposeInternal() {
    }

    protected JTextField getFilterField() {
        return this.m_filterPanel.getFilterField();
    }

    protected final void updateBorderText(String text2) {
        Preconditions.checkNotNull(text2, "IE01842: Text argument can not be null");
        this.m_titledBorder.setTitle(text2);
        this.updateUI();
    }

    public void addListener(IFilterFieldListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public final void dispose() {
        if (this.m_filterFactory != null) {
            this.m_filterFactory.dispose();
        }
        if (this.m_filterPanel != null) {
            this.m_filterPanel.dispose();
            this.m_filterPanel.removeListener(this.m_filterListener);
        }
        this.m_table.dispose();
        this.disposeInternal();
    }

    public final IFilteredTable<T> getTable() {
        return this.m_table;
    }

    public void removeListener(IFilterFieldListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_table.setEnabled(enabled);
        if (this.m_filterPanel != null) {
            this.m_filterPanel.setEnabled(enabled);
        }
    }

    private class InternalFilterPanelListener
    implements IFilterPanelListener<T> {
        private InternalFilterPanelListener() {
        }

        @Override
        public void changedFilter(CFilterPanel<T> filterPanel, IFilter<T> filter) {
            CTablePanel.this.getTable().getTreeTableModel().setFilter(filter);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            for (IFilterFieldListener listener : CTablePanel.this.m_listeners) {
                try {
                    listener.mousePressed(event);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            for (IFilterFieldListener listener : CTablePanel.this.m_listeners) {
                try {
                    listener.mouseReleased(event);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

