/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.FilterPanel;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterComponent;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterComponentListener;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterFactory;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterPanelListener;
import com.google.security.zynamics.binnavi.Help.CHelpTextField;
import com.google.security.zynamics.binnavi.Help.IHelpInformation;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.antlr.runtime.RecognitionException;

public final class CFilterPanel<T>
extends JPanel {
    private static final long serialVersionUID = 7546909182146443491L;
    private final JTextField m_inputField;
    private final ListenerProvider<IFilterPanelListener<T>> m_listeners = new ListenerProvider();
    private final IFilterFactory<T> m_filterFactory;
    private final MouseListener m_internalMouseListener = new InternalMouseListener();
    private final IFilterComponentListener m_filterComponentListener = new InternalFilterComponentListener();

    public CFilterPanel(IFilterFactory<T> filterFactory, IHelpInformation filterHelp) {
        super(new BorderLayout());
        this.m_filterFactory = filterFactory;
        this.m_inputField = new CHelpTextField(filterHelp);
        this.m_inputField.addMouseListener(this.m_internalMouseListener);
        this.add(this.m_inputField);
        this.m_inputField.getDocument().addDocumentListener(new InternalDocumentListener());
        IFilterComponent<T> filterComponent = filterFactory.getFilterComponent();
        if (filterComponent != null) {
            this.add(filterComponent.getComponent(), "West");
            filterComponent.addListener(this.m_filterComponentListener);
        }
        this.setBorder(new TitledBorder("Filter"));
    }

    private void updateFilter() {
        IFilter<T> filter;
        try {
            filter = this.m_filterFactory.createFilter(this.m_inputField.getText());
            this.m_inputField.setBackground(Color.WHITE);
        }
        catch (RecognitionException e2) {
            this.m_inputField.setBackground(Color.RED.brighter().brighter());
            return;
        }
        for (IFilterPanelListener<T> listener : this.m_listeners) {
            try {
                listener.changedFilter(this, filter);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void addListener(IFilterPanelListener<T> listener) {
        this.m_listeners.addListener(listener);
    }

    public void dispose() {
        IFilterComponent<T> filterComponent = this.m_filterFactory.getFilterComponent();
        if (filterComponent != null) {
            filterComponent.removeListener(this.m_filterComponentListener);
        }
    }

    public JTextField getFilterField() {
        return this.m_inputField;
    }

    public void removeListener(IFilterPanelListener<T> listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_inputField.setEnabled(enabled);
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            for (IFilterPanelListener listener : CFilterPanel.this.m_listeners) {
                try {
                    listener.mousePressed(event);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            for (IFilterPanelListener listener : CFilterPanel.this.m_listeners) {
                try {
                    listener.mouseReleased(event);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }

    private class InternalFilterComponentListener
    implements IFilterComponentListener {
        private InternalFilterComponentListener() {
        }

        @Override
        public void updated() {
            CFilterPanel.this.updateFilter();
        }
    }

    private class InternalDocumentListener
    implements DocumentListener {
        private InternalDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            CFilterPanel.this.updateFilter();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            CFilterPanel.this.updateFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            CFilterPanel.this.updateFilter();
        }
    }
}

