/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.DragAndDrop;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.DragAndDrop.IDropHandler;
import com.google.security.zynamics.zylib.gui.dndtree.AbstractTreeTransferHandler;
import com.google.security.zynamics.zylib.gui.dndtree.DNDTree;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public final class CDefaultTransferHandler
extends AbstractTreeTransferHandler {
    private final List<IDropHandler> m_handlers;
    private IDropHandler m_activeHandler = null;

    public CDefaultTransferHandler(DNDTree tree, int action, List<IDropHandler> handlers2) {
        super(tree, action, true);
        Preconditions.checkNotNull(handlers2, "IE01930: Handlers argument can not be null");
        for (IDropHandler handler2 : handlers2) {
            Preconditions.checkNotNull(handler2, "IE01931: Handlers list contains a null-element");
        }
        this.m_handlers = new ArrayList<IDropHandler>(handlers2);
    }

    @Override
    protected boolean canPerformAction(DNDTree target, DataFlavor flavor, Transferable transferable, int action, Point location) {
        for (IDropHandler handler2 : this.m_handlers) {
            if (!handler2.canHandle(target, transferable, flavor, location.x, location.y)) continue;
            this.m_activeHandler = handler2;
            return true;
        }
        return false;
    }

    @Override
    protected boolean executeDrop(DNDTree tree, Transferable transferable, DefaultMutableTreeNode newParentNode, int action) {
        this.m_activeHandler.drop(transferable, newParentNode);
        return true;
    }

    @Override
    public boolean canPerformAction(DNDTree target, DefaultMutableTreeNode draggedNode, int action, Point location) {
        TreePath pathTarget = target.getPathForLocation(location.x, location.y);
        if (pathTarget == null) {
            target.setSelectionPath(null);
            return false;
        }
        target.setSelectionPath(pathTarget);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
        for (IDropHandler handler2 : this.m_handlers) {
            if (!handler2.canHandle(parentNode, draggedNode)) continue;
            this.m_activeHandler = handler2;
            return true;
        }
        return false;
    }

    @Override
    public boolean executeDrop(DNDTree target, DefaultMutableTreeNode draggedNode, DefaultMutableTreeNode newParentNode, int action) {
        this.m_activeHandler.drop(target, newParentNode, draggedNode);
        return true;
    }
}

