/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations.CStartTraceListener;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations.CStopTraceListener;
import com.google.security.zynamics.binnavi.Gui.Debug.TraceOptionsDialog.CTraceOptionsDialog;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.helpers.BreakpointableNodeCounter;
import com.google.security.zynamics.binnavi.debug.helpers.EchoBreakpointCollector;
import com.google.security.zynamics.binnavi.debug.helpers.NodeBreakpointDecider;
import com.google.security.zynamics.binnavi.debug.helpers.NodeBreakpointIterator;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceLogger;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.util.Set;
import javax.swing.JFrame;

public final class CTraceFunctions {
    private CTraceFunctions() {
    }

    private static void checkArguments(JFrame parent, IDebugger debugger, TraceLogger logger) {
        Preconditions.checkNotNull(parent, "IE01566: Parent argument can not be null");
        Preconditions.checkNotNull(debugger, "IE01567: Debugger argument can not be null");
        Preconditions.checkNotNull(logger, "IE01568: Logger argument can not be null");
    }

    private static int countEchoBreakpoints(BreakpointManager manager, ZyGraph graph) {
        BreakpointableNodeCounter ebc = new BreakpointableNodeCounter(manager);
        NodeBreakpointIterator.iterate(graph, ebc);
        return ebc.getCount();
    }

    private static TraceList createTrace(JFrame parent, TraceLogger logger) {
        try {
            String name = logger.getTraceProvider().generateName();
            return logger.getTraceProvider().createTrace(name, "");
        }
        catch (CouldntSaveDataException exception) {
            CUtilityFunctions.logException(exception);
            String innerMessage = "E00095: Creating the new trace failed";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not create the new trace in the database.", new String[]{"There was a problem with the database connection."}, new String[]{"The debugger will not enter trace mode. You can try to start trace mode again after you have resolved the database connection problem."});
            NaviErrorDialog.show(parent, "E00095: Creating the new trace failed", innerDescription, exception);
            return null;
        }
    }

    private static void saveTrace(TraceList trace2) {
        try {
            trace2.save();
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
        }
    }

    private static void showStartTraceProgressWindow(JFrame parent, Set<BreakpointAddress> addresses, TraceLogger logger, int maximumHits) {
        TraceList trace2 = CTraceFunctions.createTrace(parent, logger);
        CStartTraceListener bpl = new CStartTraceListener(logger, trace2, addresses, maximumHits);
        CProgressDialog.showEndless(parent, "Setting echo breakpoints", bpl);
    }

    public static void startTrace(JFrame parent, IDebugger debugger, ZyGraph graph, TraceLogger logger) {
        CTraceFunctions.checkArguments(parent, debugger, logger);
        Preconditions.checkNotNull(graph, "IE01569: Graph argument can not be null");
        if (!debugger.isConnected()) {
            return;
        }
        if (logger.hasEchoBreakpoints()) {
            TraceList trace2 = CTraceFunctions.createTrace(parent, logger);
            if (trace2 == null) {
                return;
            }
            TraceList oldTrace = logger.switchTargetList(trace2);
            CTraceFunctions.saveTrace(oldTrace);
        } else {
            int bps = CTraceFunctions.countEchoBreakpoints(debugger.getBreakpointManager(), graph);
            if (bps == 0) {
                CMessageBox.showError(parent, "All nodes of the graph are already covered by another active trace");
            } else {
                CTraceOptionsDialog dlg = CTraceOptionsDialog.show(parent);
                if (!dlg.wasCancelled()) {
                    int maximumHits = dlg.getMaximumHits();
                    if (maximumHits == 0) {
                        return;
                    }
                    EchoBreakpointCollector ebc = new EchoBreakpointCollector(debugger.getBreakpointManager());
                    graph.iterate(new NodeBreakpointDecider(ebc));
                    CTraceFunctions.showStartTraceProgressWindow(parent, ebc.getBreakpoints(), logger, maximumHits);
                }
            }
        }
    }

    public static void stopTrace(JFrame parent, IDebugger debugger, TraceLogger logger) {
        CTraceFunctions.checkArguments(parent, debugger, logger);
        if (!debugger.isConnected()) {
            return;
        }
        if (!logger.hasEchoBreakpoints()) {
            return;
        }
        CStopTraceListener bpl = new CStopTraceListener(debugger, logger);
        CProgressDialog.showEndless(parent, "Removing echo breakpoints", bpl);
    }
}

