/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations;

import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CSteppingHelper {
    private CSteppingHelper() {
    }

    private static BreakpointAddress getAddress(INaviViewNode node) {
        if (node instanceof INaviCodeNode) {
            INaviCodeNode ccnode = (INaviCodeNode)node;
            INaviInstruction instruction = Iterables.getFirst(ccnode.getInstructions(), null);
            return new BreakpointAddress(instruction.getModule(), new UnrelocatedAddress(instruction.getAddress()));
        }
        if (node instanceof INaviFunctionNode) {
            INaviFunction function = ((INaviFunctionNode)node).getFunction();
            INaviModule module = function.getModule();
            return new BreakpointAddress(module, new UnrelocatedAddress(function.getAddress()));
        }
        return null;
    }

    public static Set<BreakpointAddress> getSuccessors(INaviViewNode node) {
        HashSet<BreakpointAddress> addresses = new HashSet<BreakpointAddress>();
        List<INaviEdge> edges = node.getOutgoingEdges();
        for (INaviEdge edge : edges) {
            BreakpointAddress childAddress = CSteppingHelper.getAddress((INaviViewNode)edge.getTarget());
            if (childAddress == null) continue;
            addresses.add(childAddress);
        }
        return addresses;
    }
}

