/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations;

import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import java.util.HashSet;
import java.util.Set;

public final class CStepEndHelper {
    private CStepEndHelper() {
    }

    public static Set<BreakpointAddress> getEndAddresses(ZyGraph graph) {
        final HashSet<BreakpointAddress> instructions = new HashSet<BreakpointAddress>();
        graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode node) {
                if (node.getRawNode() instanceof INaviCodeNode && node.getChildren().isEmpty()) {
                    INaviCodeNode cnode = (INaviCodeNode)node.getRawNode();
                    INaviInstruction lastInstruction = (INaviInstruction)Iterables.getLast(cnode.getInstructions());
                    instructions.add(new BreakpointAddress(lastInstruction.getModule(), new UnrelocatedAddress(lastInstruction.getAddress())));
                }
                return IterationMode.CONTINUE;
            }
        });
        return instructions;
    }
}

