/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.Debug.Notifier.CDebugEventNotifier;
import com.google.security.zynamics.binnavi.Gui.Debug.OptionsDialog.COptionsDialog;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations.CStepBlockHelper;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations.CStepEndHelper;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations.CStepOverHelper;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.DebugTargetSettings;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.storage.DebuggerEventSettingsStorage;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerEventSettings;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerExceptionHandlingAction;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerOptions;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;

public final class CDebuggerFunctions {
    private static void checkArguments(JFrame parent, IDebugger debugger) {
        Preconditions.checkNotNull(parent, "IE01552: Parent argument can not be null");
        Preconditions.checkNotNull(debugger, "IE01553: Debugger argument can not be null");
    }

    private static void checkArguments(JFrame parent, IDebugger debugger, ZyGraph graph) {
        CDebuggerFunctions.checkArguments(parent, debugger);
        Preconditions.checkNotNull(graph, "IE01555: Graph argument can not be null");
    }

    private static Map<Long, DebuggerException> getExceptionsMap(Collection<DebuggerException> exceptions2) {
        HashMap<Long, DebuggerException> result = new HashMap<Long, DebuggerException>();
        for (DebuggerException exception : exceptions2) {
            result.put(exception.getExceptionCode(), exception);
        }
        return result;
    }

    private static DebuggerEventSettings readDebuggerEventSettings(JFrame parent, IDebugger debugger, DebugTargetSettings target) {
        DebuggerEventSettingsStorage eventSettingsStorage = new DebuggerEventSettingsStorage(debugger, target);
        try {
            return eventSettingsStorage.deserialize();
        }
        catch (CouldntLoadDataException exception) {
            CUtilityFunctions.logException(exception);
            String innerMessage = "Could not send debugger event settings command";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not send the debugger event settings command to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The state of the debugged process remains unchanged."});
            NaviErrorDialog.show(parent, "Could not send debugger event settings command", innerDescription, exception);
            return null;
        }
    }

    private static void sendExceptionSettings(JFrame parent, IDebugger debugger, Collection<DebuggerException> exceptions2) {
        Preconditions.checkNotNull(exceptions2, "IE00679: Exceptions argument can not be null");
        try {
            debugger.setExceptionSettings(exceptions2);
        }
        catch (DebugExceptionWrapper e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "Could not send exceptions settings command";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not send the exception settings command to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The state of the debugged process remains unchanged."});
            NaviErrorDialog.show(parent, "Could not send exceptions settings command", innerDescription, e2);
        }
    }

    private static void writeDebuggerEventSettings(IDebugger debugger, DebugTargetSettings debugTarget, DebuggerEventSettings eventSettings) throws CouldntSaveDataException {
        DebuggerEventSettingsStorage eventSettingsStorage = new DebuggerEventSettingsStorage(debugger, debugTarget);
        eventSettingsStorage.serialize(eventSettings);
    }

    private static void writeDebuggerExceptionSettings(DebuggerOptions options, DebugTargetSettings target, int debuggerId) throws CouldntSaveDataException {
        target.writeSetting("show_debugger_options", "1");
        for (DebuggerException pe : options.getExceptions()) {
            target.writeSetting(DebuggerException.getSettingKey(pe, debuggerId), Integer.toString(pe.getExceptionAction().getValue()));
        }
    }

    public static void attach(JFrame parent, IDebugger debugger, CDebugEventNotifier notifier) {
        try {
            notifier.start();
            debugger.connect();
        }
        catch (DebugExceptionWrapper exception) {
            notifier.stop();
            CUtilityFunctions.logException(exception);
            String innerMessage = "E00082: Could not attach to the debug client";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not attach to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The debugger process was not started yet. You can try to debug the client again once you resolved the connection problems."});
            NaviErrorDialog.show(parent, "E00082: Could not attach to the debug client", innerDescription, exception);
        }
    }

    public static void detach(JFrame parent, IDebugger debugger) {
        CDebuggerFunctions.checkArguments(parent, debugger);
        if (!debugger.isConnected()) {
            return;
        }
        try {
            debugger.detach();
        }
        catch (DebugExceptionWrapper exception) {
            CUtilityFunctions.logException(exception);
            String innerMessage = "E00073: Could not send detach command";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not send the detach command to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The debugger remains attached to the debug target."});
            NaviErrorDialog.show(parent, "E00073: Could not send detach command", innerDescription, exception);
        }
    }

    public static void halt(JFrame parent, IDebugger debugger) {
        CDebuggerFunctions.checkArguments(parent, debugger);
        if (!debugger.isConnected()) {
            return;
        }
        try {
            debugger.halt();
        }
        catch (DebugExceptionWrapper e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00083: Could not send halt command";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not send the halt command to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The state of the debugged process remains unchanged."});
            NaviErrorDialog.show(parent, "E00083: Could not send halt command", innerDescription, e2);
        }
    }

    public static Collection<DebuggerException> mergeExceptionsSettings(DebugTargetSettings target, Collection<DebuggerException> exceptions2, int debuggerId) throws CouldntLoadDataException {
        Map<Long, DebuggerException> exceptionsMap = CDebuggerFunctions.getExceptionsMap(exceptions2);
        for (DebuggerException dbgException : exceptions2) {
            String setting = target.readSetting(DebuggerException.getSettingKey(dbgException, debuggerId));
            if (setting == null) continue;
            DebuggerExceptionHandlingAction handlingAction = DebuggerExceptionHandlingAction.convertToHandlingAction(Integer.valueOf(setting));
            DebuggerException newException = new DebuggerException(dbgException.getExceptionName(), dbgException.getExceptionCode(), handlingAction);
            exceptionsMap.put(dbgException.getExceptionCode(), newException);
        }
        return exceptionsMap.values();
    }

    public static void resume(JFrame parent, IDebugger debugger) {
        CDebuggerFunctions.checkArguments(parent, debugger);
        if (!debugger.isConnected()) {
            return;
        }
        try {
            debugger.getProcessManager().setActiveThread(null);
            debugger.resume();
        }
        catch (DebugExceptionWrapper e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00029: Could not send resume command to the debug client";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not send the resume command to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The state of the debugged process remains unchanged."});
            NaviErrorDialog.show(parent, "E00029: Could not send resume command to the debug client", innerDescription, e2);
        }
    }

    public static void sendDebuggerEventSettings(JFrame parent, IDebugger debugger, DebugTargetSettings debugTarget) {
        try {
            DebuggerEventSettingsStorage eventSettingsStorage = new DebuggerEventSettingsStorage(debugger, debugTarget);
            debugger.setDebuggerEventSettings(eventSettingsStorage.deserialize());
        }
        catch (DebugExceptionWrapper exception) {
            CUtilityFunctions.logException(exception);
            String message2 = "Debugger event settings could not be sent to the debugger.";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not send the debugger event settings to the debug client.", new Object[0]), new String[0], new String[]{"The default debugger event settings will be used during this session."});
            NaviErrorDialog.show(parent, "Debugger event settings could not be sent to the debugger.", description, exception);
        }
        catch (CouldntLoadDataException exception) {
            CUtilityFunctions.logException(exception);
            String message3 = "Debugger event settings could not be retrieved from the database.";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not send the debugger event settings to the debug client.", new Object[0]), new String[0], new String[]{"The default debugger event settings will be used during this session."});
            NaviErrorDialog.show(parent, "Debugger event settings could not be retrieved from the database.", description, exception);
        }
    }

    public static void showDebuggerOptionsDialogAlways(JFrame parent, DebugTargetSettings target, IDebugger debugger) {
        Preconditions.checkNotNull(parent, "IE01559: Parent argument can not be null");
        Preconditions.checkNotNull(target, "IE01560: Target argument can not be null");
        Preconditions.checkNotNull(debugger, "IE01561: Debugger argument can not be null");
        TargetInformation targetInformation = debugger.getProcessManager().getTargetInformation();
        if (targetInformation == null) {
            CMessageBox.showInformation(parent, "Debugger information can not be shown before the debugger is active.");
            return;
        }
        DebuggerOptions options = targetInformation.getDebuggerOptions();
        if (options == null) {
            CMessageBox.showInformation(parent, "Debugger information can not be shown before the debugger is active.");
            return;
        }
        if (!debugger.isConnected()) {
            CMessageBox.showInformation(parent, "Debugger information can not be shown since the debugger is not currently connected.");
            return;
        }
        try {
            options.setExceptions(new ArrayList<DebuggerException>(CDebuggerFunctions.mergeExceptionsSettings(target, options.getExceptions(), debugger.getId())));
        }
        catch (CouldntLoadDataException exception) {
            CUtilityFunctions.logException(exception);
            String message2 = "Exception settings could not be loaded.";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not load the exception settings from the database.", new Object[0]), new String[]{"Communication error while contacting the database"}, new String[]{"BinNavi is unable to show the debugger options dialog until the problem is resolved. The default debugger options will be used during this session."});
            NaviErrorDialog.show(parent, "Exception settings could not be loaded.", description, exception);
        }
        DebuggerEventSettings eventSettings = CDebuggerFunctions.readDebuggerEventSettings(parent, debugger, target);
        COptionsDialog dlg = new COptionsDialog(parent, options, eventSettings);
        dlg.setVisible(true);
        options = dlg.getDebuggerOptions();
        try {
            CDebuggerFunctions.writeDebuggerExceptionSettings(options, target, debugger.getId());
            CDebuggerFunctions.writeDebuggerEventSettings(debugger, target, dlg.getDebuggerEventSettings());
        }
        catch (CouldntSaveDataException exception) {
            CUtilityFunctions.logException(exception);
            CUtilityFunctions.logException(exception);
            String message3 = "Exception settings could not be written.";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not write the debugger options to the database.", new Object[0]), new String[]{"Communication error while contacting the database"}, new String[]{"BinNavi is unable to store the debugger options in the database.", "Nevertheless, the debugger options will be sent to the debugger."});
            NaviErrorDialog.show(parent, "Exception settings could not be written.", description, exception);
        }
        CDebuggerFunctions.sendExceptionSettings(parent, debugger, options.getExceptions());
        CDebuggerFunctions.sendDebuggerEventSettings(parent, debugger, target);
    }

    public static void stepBlock(JFrame parent, IDebugger debugger, ZyGraph graph) {
        CDebuggerFunctions.checkArguments(parent, debugger, graph);
        if (!debugger.isConnected()) {
            return;
        }
        TargetProcessThread activeThread = debugger.getProcessManager().getActiveThread();
        if (activeThread == null) {
            return;
        }
        RelocatedAddress currentAddress = activeThread.getCurrentAddress();
        if (currentAddress == null) {
            CMessageBox.showError(parent, "Could not step because the selected thread is not suspended");
            return;
        }
        UnrelocatedAddress oldAddress = debugger.memoryToFile(currentAddress);
        Set<BreakpointAddress> relocatedBlockAddresses = CStepBlockHelper.getNextBlocks(graph, oldAddress);
        if (relocatedBlockAddresses.isEmpty()) {
            CMessageBox.showError(parent, "Couldn't step to the next block");
            return;
        }
        debugger.getProcessManager().setActiveThread(null);
        HashSet<BreakpointAddress> setBreakpoints = new HashSet<BreakpointAddress>();
        debugger.getBreakpointManager().addBreakpoints(BreakpointType.STEP, relocatedBlockAddresses);
        setBreakpoints.addAll(relocatedBlockAddresses);
        try {
            debugger.resume();
        }
        catch (DebugExceptionWrapper e2) {
            debugger.getProcessManager().setActiveThread(activeThread);
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00045: Could not send step block command to the debug client";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not send the step block command to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The state of the debugged process remains unchanged."});
            NaviErrorDialog.show(parent, "E00045: Could not send step block command to the debug client", innerDescription, e2);
        }
    }

    public static void stepEnd(JFrame parent, IDebugger debugger, ZyGraph graph) {
        CDebuggerFunctions.checkArguments(parent, debugger, graph);
        if (!debugger.isConnected()) {
            return;
        }
        TargetProcessThread activeThread = debugger.getProcessManager().getActiveThread();
        if (activeThread == null) {
            return;
        }
        RelocatedAddress currentAddress = activeThread.getCurrentAddress();
        if (currentAddress == null) {
            CMessageBox.showError(parent, "Could not step because the selected thread is not suspended");
            return;
        }
        Set<BreakpointAddress> relocatedBlockAddresses = CStepEndHelper.getEndAddresses(graph);
        if (relocatedBlockAddresses.isEmpty()) {
            CMessageBox.showError(parent, "Couldn't step to the end of the function");
            return;
        }
        debugger.getProcessManager().setActiveThread(null);
        debugger.getBreakpointManager().addBreakpoints(BreakpointType.STEP, relocatedBlockAddresses);
        try {
            debugger.resume();
        }
        catch (DebugExceptionWrapper e2) {
            debugger.getBreakpointManager().removeBreakpoints(BreakpointType.STEP, relocatedBlockAddresses);
            debugger.getProcessManager().setActiveThread(activeThread);
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00086: Could not send step end command to the debug client";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not send the step end command to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The state of the debugged process remains unchanged."});
            NaviErrorDialog.show(parent, "E00086: Could not send step end command to the debug client", innerDescription, e2);
        }
    }

    public static void stepInto(JFrame parent, IDebugger debugger) {
        CDebuggerFunctions.checkArguments(parent, debugger);
        if (!debugger.isConnected()) {
            return;
        }
        TargetProcessThread activeThread = debugger.getProcessManager().getActiveThread();
        try {
            debugger.getProcessManager().setActiveThread(null);
            debugger.singleStep();
        }
        catch (DebugExceptionWrapper e2) {
            CUtilityFunctions.logException(e2);
            debugger.getProcessManager().setActiveThread(activeThread);
            String innerMessage = "E00192: Could not send single step command to the debug client";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not send the single step command to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The state of the debugged process remains unchanged."});
            NaviErrorDialog.show(parent, "E00192: Could not send single step command to the debug client", innerDescription, e2);
        }
    }

    public static void stepOver(JFrame parent, IDebugger debugger, ZyGraph graph) {
        CDebuggerFunctions.checkArguments(parent, debugger, graph);
        if (!debugger.isConnected()) {
            return;
        }
        TargetProcessThread activeThread = debugger.getProcessManager().getActiveThread();
        if (activeThread == null) {
            return;
        }
        RelocatedAddress currentAddress = activeThread.getCurrentAddress();
        if (currentAddress == null) {
            CMessageBox.showError(parent, "Could not step because the selected thread is not suspended");
            return;
        }
        UnrelocatedAddress oldAddress = debugger.memoryToFile(currentAddress);
        Set<BreakpointAddress> relocatedAddresses = CStepOverHelper.getNextInstructions(graph, oldAddress);
        if (relocatedAddresses.isEmpty()) {
            CMessageBox.showError(parent, "Couldn't step over the current instruction");
            return;
        }
        debugger.getProcessManager().setActiveThread(null);
        debugger.getBreakpointManager().addBreakpoints(BreakpointType.STEP, relocatedAddresses);
        try {
            debugger.resume();
        }
        catch (DebugExceptionWrapper e2) {
            debugger.getProcessManager().setActiveThread(activeThread);
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00087: Could not send step over command to the debug client";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not send the step over command to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The state of the debugged process remains unchanged."});
            NaviErrorDialog.show(parent, "E00087: Could not send step over command to the debug client", innerDescription, e2);
        }
    }

    public static void terminate(JFrame parent, IDebugger debugger) {
        CDebuggerFunctions.checkArguments(parent, debugger);
        try {
            if (debugger.isConnected()) {
                debugger.terminate();
            }
        }
        catch (DebugExceptionWrapper e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00193: Could not send terminate command to the debug client";
            String innerDescription = CUtilityFunctions.createDescription("BinNavi could not send the terminate command to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The state of the debugged process remains unchanged."});
            NaviErrorDialog.show(parent, "E00193: Could not send terminate command to the debug client", innerDescription, e2);
        }
    }
}

