/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions.CAttachAction;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions.CDetachAction;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions.CHaltAction;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions.CResumeAction;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions.CStartTraceAction;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions.CStepBlockAction;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions.CStepEndAction;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions.CStepIntoAction;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions.CStepOverAction;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions.CStopTraceAction;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions.CTerminateAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IFrontEndDebuggerProvider;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerOptions;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public final class CDebuggerToolbar
extends JToolBar {
    private final IFrontEndDebuggerProvider m_debugger;
    private final Action m_detachAction;
    private final Action m_startAction;
    private final Action m_terminateAction;
    private final Action m_stepIntoAction;
    private final Action m_stepOverAction;
    private final Action m_startTraceAction;
    private final Action m_stopTraceAction;
    private final Action m_stepBlockAction;
    private final Action m_stepEndAction;
    private final Action m_resumeAction;
    private final JButton m_detachButton;
    private final JButton m_terminateButton;
    private final Action m_haltAction;
    private final JButton m_haltButton;

    public CDebuggerToolbar(CDebugPerspectiveModel debugger) {
        this.m_debugger = debugger;
        this.setFloatable(false);
        IGraphModel model = debugger.getGraphModel();
        CGraphWindow parent = model.getParent();
        ZyGraph graph = model.getGraph();
        this.m_startAction = new CAttachAction(parent, debugger);
        this.m_detachAction = new CDetachAction(parent, debugger);
        this.m_terminateAction = new CTerminateAction(parent, debugger);
        this.m_stepIntoAction = new CStepIntoAction(parent, debugger);
        this.m_stepOverAction = new CStepOverAction(parent, debugger, graph);
        this.m_stepBlockAction = new CStepBlockAction(parent, debugger, graph);
        this.m_stepEndAction = new CStepEndAction(parent, debugger, graph);
        this.m_resumeAction = new CResumeAction(parent, debugger);
        this.m_haltAction = new CHaltAction(parent, debugger);
        this.m_startTraceAction = new CStartTraceAction(parent, debugger, graph);
        this.m_stopTraceAction = new CStopTraceAction(parent, debugger);
        this.createAndAddIconToToolbar(this.m_startAction, "data/startdebugger_up.jpg", "data/startdebugger_hover.jpg", "data/startdebugger_down.jpg");
        this.m_detachButton = this.createAndAddIconToToolbar(this.m_detachAction, "data/detachdebugger_up.jpg", "data/detachdebugger_hover.jpg", "data/detachdebugger_down.jpg");
        this.m_terminateButton = this.createAndAddIconToToolbar(this.m_terminateAction, "data/terminatedebugger_up.jpg", "data/terminatedebugger_hover.jpg", "data/terminatedebugger_down.jpg");
        JButton stepButton = this.createAndAddIconToToolbar(this.m_stepIntoAction, "data/stepnext_up.jpg", "data/stepnext_hover.jpg", "data/stepnext_down.jpg");
        CDebuggerToolbar.addHotkey(stepButton, HotKeys.DEBUGGER_SINGLE_STEP_KEY.getKeyStroke(), this.m_stepIntoAction, HotKeys.DEBUGGER_SINGLE_STEP_KEY.getDescription());
        JButton stepOverButton = this.createAndAddIconToToolbar(this.m_stepOverAction, "data/stepover_up.jpg", "data/stepover_hover.jpg", "data/stepover_down.jpg");
        CDebuggerToolbar.addHotkey(stepOverButton, HotKeys.DEBUGGER_STEP_OVER_KEY.getKeyStroke(), this.m_stepOverAction, HotKeys.DEBUGGER_STEP_OVER_KEY.getDescription());
        JButton stepBlockButton = this.createAndAddIconToToolbar(this.m_stepBlockAction, "data/stepnextnode_up.jpg", "data/stepnextnode_hover.jpg", "data/stepnextnode_down.jpg");
        CDebuggerToolbar.addHotkey(stepBlockButton, HotKeys.DEBUGGER_STEP_BLOCK_KEY.getKeyStroke(), this.m_stepBlockAction, HotKeys.DEBUGGER_STEP_BLOCK_KEY.getDescription());
        this.createAndAddIconToToolbar(this.m_stepEndAction, "data/step_to_end_up.png", "data/step_to_end_hover.png", "data/step_to_end_down.png");
        JButton resumeButton = this.createAndAddIconToToolbar(this.m_resumeAction, "data/resumedebugger_up.jpg", "data/resumedebugger_hover.jpg", "data/resumedebugger_down.jpg");
        CDebuggerToolbar.addHotkey(resumeButton, HotKeys.DEBUGGER_RESUME_KEY.getKeyStroke(), this.m_resumeAction, HotKeys.DEBUGGER_RESUME_KEY.getDescription());
        this.m_haltButton = this.createAndAddIconToToolbar(this.m_haltAction, "data/suspenddebugger_up.jpg", "data/suspenddebugger_hover.jpg", "data/suspenddebugger_down.jpg");
        this.createAndAddIconToToolbar(this.m_startTraceAction, "data/record_up.jpg", "data/record_hover.jpg", "data/record_down.jpg");
        this.createAndAddIconToToolbar(this.m_stopTraceAction, "data/recordstop_up.jpg", "data/recordstop_hover.jpg", "data/recordstop_down.jpg");
    }

    private static void addHotkey(JButton button, KeyStroke keyStroke, Action action, String name) {
        InputMap windowImap = button.getInputMap(2);
        windowImap.put(keyStroke, name);
        button.getActionMap().put(name, action);
    }

    private JButton createAndAddIconToToolbar(Action action, String defaultIconPath, String rolloverIconPath, String pressedIconPath) {
        JButton button = this.add(CActionProxy.proxy(action));
        button.setBorder(new EmptyBorder(0, 0, 0, 0));
        button.setIcon(new ImageIcon(CMain.class.getResource(defaultIconPath)));
        button.setRolloverIcon(new ImageIcon(CMain.class.getResource(rolloverIconPath)));
        button.setPressedIcon(new ImageIcon(CMain.class.getResource(pressedIconPath)));
        return button;
    }

    public void updateFromDebuggerOptions(DebuggerOptions options) {
        Preconditions.checkNotNull(options, "IE01521: Options argument can not be null");
        this.m_detachButton.setEnabled(options.canDetach());
        this.m_terminateButton.setEnabled(options.canTerminate());
        this.m_haltButton.setEnabled(options.canHalt());
        this.updateGui();
    }

    public void updateGui() {
        IDebugger debugger = this.m_debugger.getCurrentSelectedDebugger();
        TargetProcessThread activeThread = debugger == null ? null : debugger.getProcessManager().getActiveThread();
        boolean connected = debugger != null && debugger.isConnected();
        boolean suspended = connected && activeThread != null;
        this.m_startAction.setEnabled(!connected);
        boolean haltBeforeCommunicating = debugger != null && connected && debugger.getProcessManager().getTargetInformation() != null && debugger.getProcessManager().getTargetInformation().getDebuggerOptions().mustHaltBeforeCommunicating();
        this.m_detachAction.setEnabled(connected && (!haltBeforeCommunicating || suspended));
        this.m_terminateAction.setEnabled(connected);
        this.m_stepIntoAction.setEnabled(connected && suspended);
        this.m_stepIntoAction.setEnabled(connected && suspended);
        this.m_stepOverAction.setEnabled(connected && suspended);
        this.m_stepBlockAction.setEnabled(connected && suspended);
        this.m_stepEndAction.setEnabled(connected && suspended);
        this.m_resumeAction.setEnabled(connected && suspended);
        this.m_haltAction.setEnabled(connected && !suspended);
        boolean tracing = debugger != null && this.m_debugger.getTraceLogger(debugger).hasEchoBreakpoints();
        this.m_startTraceAction.setEnabled(connected && (!haltBeforeCommunicating || suspended));
        this.m_stopTraceAction.setEnabled(connected && tracing && (!haltBeforeCommunicating || suspended));
    }
}

