/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations.CDebuggerFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IFrontEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public final class CAttachAction
extends AbstractAction {
    private final JFrame m_parent;
    private final IFrontEndDebuggerProvider m_frontEndDebuggerProvider;

    public CAttachAction(JFrame parent, IFrontEndDebuggerProvider frontEndDebuggerProvider) {
        this.m_parent = Preconditions.checkNotNull(parent, "IE00269: Parent argument can not be null");
        this.m_frontEndDebuggerProvider = Preconditions.checkNotNull(frontEndDebuggerProvider, "IE01528: Debugger argument can not be null");
        this.putValue("ShortDescription", "Start Debugger");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        IDebugger debugger = this.m_frontEndDebuggerProvider.getCurrentSelectedDebugger();
        if (debugger == null) {
            CMessageBox.showInformation(this.m_parent, "No debugger selected. Did you configure a debugger for this module?");
        } else {
            CDebuggerFunctions.attach(this.m_parent, debugger, this.m_frontEndDebuggerProvider.getNotifier(debugger));
        }
    }
}

