/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ThreadPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.ThreadPanel.CThreadComboBox;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;

public final class CThreadPanelSynchronizer {
    private final CThreadComboBox m_tidBox;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final ItemListener m_boxListener = new InternalBoxListener();
    private final IDebugPerspectiveModelListener m_debugListener = new InternalDebugListener();
    private final ProcessManagerListener m_processListener = new InternalProcessListener();

    public CThreadPanelSynchronizer(CThreadComboBox tidBox, CDebugPerspectiveModel debugPerspectiveModel) {
        this.m_tidBox = Preconditions.checkNotNull(tidBox, "IE01519: Thead box argument can not be null");
        this.m_debugPerspectiveModel = Preconditions.checkNotNull(debugPerspectiveModel, "IE01520: Debug perspective model argument can not be null");
        this.m_debugPerspectiveModel.addListener(this.m_debugListener);
        this.m_tidBox.addItemListener(this.m_boxListener);
        this.synchronizeDebugger(null, debugPerspectiveModel.getCurrentSelectedDebugger());
        this.updateGui();
    }

    private void synchronizeDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
        if (oldDebugger != null) {
            oldDebugger.getProcessManager().removeListener(this.m_processListener);
        }
        if (newDebugger != null) {
            newDebugger.getProcessManager().addListener(this.m_processListener);
        }
    }

    private void updateGui() {
        this.m_tidBox.removeAllItems();
        IDebugger debugger = this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
        if (debugger == null) {
            this.m_tidBox.setEnabled(false);
        } else {
            List<TargetProcessThread> threads = debugger.getProcessManager().getThreads();
            for (TargetProcessThread thread2 : threads) {
                this.m_tidBox.addItem(thread2);
            }
            if (!threads.isEmpty()) {
                this.m_tidBox.setSelectedIndex(0);
            }
            this.m_tidBox.setEnabled(true);
        }
    }

    public void dispose() {
        this.m_debugPerspectiveModel.removeListener(this.m_debugListener);
        this.synchronizeDebugger(this.m_debugPerspectiveModel.getCurrentSelectedDebugger(), null);
    }

    private class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void addedThread(TargetProcessThread thread2) {
            CThreadPanelSynchronizer.this.m_tidBox.addItem(thread2);
        }

        @Override
        public void attached() {
            CThreadPanelSynchronizer.this.updateGui();
        }

        @Override
        public void changedActiveThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
            CThreadPanelSynchronizer.this.m_tidBox.setSelectedItem(newThread);
        }

        @Override
        public void detached() {
            CThreadPanelSynchronizer.this.updateGui();
        }

        @Override
        public void removedThread(TargetProcessThread thread2) {
            CThreadPanelSynchronizer.this.m_tidBox.removeItem(thread2);
        }
    }

    private class InternalDebugListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalDebugListener() {
        }

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            CThreadPanelSynchronizer.this.updateGui();
            CThreadPanelSynchronizer.this.synchronizeDebugger(oldDebugger, newDebugger);
        }
    }

    private class InternalBoxListener
    implements ItemListener {
        private InternalBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            IDebugger debugger = CThreadPanelSynchronizer.this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
            if (debugger != null) {
                debugger.getProcessManager().setActiveThread(CThreadPanelSynchronizer.this.m_tidBox.getSelectedItem());
            }
        }
    }
}

