/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ThreadInformationPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.ThreadInformationPanel.CThreadInformationTable;
import com.google.security.zynamics.binnavi.Gui.Debug.ThreadInformationPanel.CThreadInformationTableModel;
import com.google.security.zynamics.binnavi.Gui.Debug.ThreadInformationPanel.CThreadInformationTableRenderer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;

public class CThreadInformationTableSynchronizer {
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final CThreadInformationTableModel m_model;
    private final IDebugPerspectiveModelListener m_listener = new InternalDebuggerListener();
    private final ProcessManagerListener m_processListener = new InternalProcessListener();
    private final CThreadInformationTableRenderer m_renderer;

    public CThreadInformationTableSynchronizer(CThreadInformationTable table, CDebugPerspectiveModel debugPerspectiveModel) {
        Preconditions.checkNotNull(table, "IE00652: Model argument can not be null");
        Preconditions.checkNotNull(debugPerspectiveModel, "IE00653: Debug perspective model argument can not be null");
        this.m_model = table.getModel();
        this.m_renderer = table.getDefaultRenderer();
        this.m_debugPerspectiveModel = debugPerspectiveModel;
        this.synchronizeDebugger(null, debugPerspectiveModel.getCurrentSelectedDebugger());
        debugPerspectiveModel.addListener(this.m_listener);
    }

    private void synchronizeDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
        if (oldDebugger != null) {
            oldDebugger.getProcessManager().removeListener(this.m_processListener);
        }
        this.m_model.reset();
        if (newDebugger != null) {
            for (TargetProcessThread thread2 : newDebugger.getProcessManager().getThreads()) {
                this.m_model.addThread(thread2);
            }
            newDebugger.getProcessManager().addListener(this.m_processListener);
        }
    }

    public void dispose() {
        this.m_debugPerspectiveModel.removeListener(this.m_listener);
        this.synchronizeDebugger(this.m_debugPerspectiveModel.getCurrentSelectedDebugger(), null);
    }

    private class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void addedThread(TargetProcessThread thread2) {
            CThreadInformationTableSynchronizer.this.m_model.addThread(thread2);
            CThreadInformationTableSynchronizer.this.m_renderer.addThread(thread2);
        }

        @Override
        public void detached() {
            CThreadInformationTableSynchronizer.this.m_model.reset();
        }

        @Override
        public void removedThread(TargetProcessThread thread2) {
            CThreadInformationTableSynchronizer.this.m_model.removeThread(thread2);
        }
    }

    private class InternalDebuggerListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalDebuggerListener() {
        }

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            CThreadInformationTableSynchronizer.this.synchronizeDebugger(oldDebugger, newDebugger);
        }
    }
}

