/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ThreadInformationPanel;

import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadState;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ThreadListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class CThreadInformationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 6479629458211965718L;
    private static final int TID_COLUMN = 0;
    private static final int STATE_COLUMN = 1;
    private static final String[] COLUMN_NAMES = new String[]{"Thread ID", "State"};
    private final List<TargetProcessThread> m_threads = new ArrayList<TargetProcessThread>();
    private final ThreadListener m_threadListener = new ThreadListenerAdapter(){

        @Override
        public void stateChanged(TargetProcessThread thread2) {
            CThreadInformationTableModel.this.fireTableDataChanged();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThread(TargetProcessThread thread2) {
        List<TargetProcessThread> list = this.m_threads;
        synchronized (list) {
            thread2.addListener(this.m_threadListener);
            this.m_threads.add(thread2);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        List<TargetProcessThread> list = this.m_threads;
        synchronized (list) {
            return this.m_threads.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TargetProcessThread> getThreads() {
        List<TargetProcessThread> list = this.m_threads;
        synchronized (list) {
            return new ArrayList<TargetProcessThread>(this.m_threads);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            List<TargetProcessThread> list = this.m_threads;
            synchronized (list) {
                TargetProcessThread thread2 = this.m_threads.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return thread2.getThreadId();
                    }
                    case 1: {
                        return thread2.getState() == ThreadState.RUNNING ? "Running" : "Suspended";
                    }
                }
                throw new IllegalStateException("IE00651: Unknown column");
            }
        }
        catch (IndexOutOfBoundsException exception) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThread(TargetProcessThread thread2) {
        List<TargetProcessThread> list = this.m_threads;
        synchronized (list) {
            thread2.removeListener(this.m_threadListener);
            this.m_threads.remove(thread2);
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        List<TargetProcessThread> list = this.m_threads;
        synchronized (list) {
            for (TargetProcessThread thread2 : this.m_threads) {
                thread2.removeListener(this.m_threadListener);
            }
            this.m_threads.clear();
        }
        this.fireTableDataChanged();
    }
}

