/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ThreadInformationPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.ThreadInformationPanel.CThreadInformationTable;
import com.google.security.zynamics.binnavi.Gui.Debug.ThreadInformationPanel.CThreadInformationTableMenu;
import com.google.security.zynamics.binnavi.Gui.Debug.ThreadInformationPanel.CThreadInformationTableSynchronizer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.CAbstractResultsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class CThreadInformationPanel
extends CAbstractResultsPanel {
    private static final long serialVersionUID = 3156187195132738483L;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final CThreadInformationTable m_table = new CThreadInformationTable();
    private final CThreadInformationTableSynchronizer m_synchronizer;

    public CThreadInformationPanel(CDebugPerspectiveModel debugPerspectiveModel) {
        super(new BorderLayout());
        Preconditions.checkNotNull(debugPerspectiveModel, "IE00647: Debug perspective model argument can not be null");
        this.m_debugPerspectiveModel = debugPerspectiveModel;
        this.add(new JScrollPane(this.m_table));
        this.m_synchronizer = new CThreadInformationTableSynchronizer(this.m_table, debugPerspectiveModel);
        this.m_table.addMouseListener(new InternalMouseListener());
    }

    @Override
    public void dispose() {
        this.m_synchronizer.dispose();
    }

    @Override
    public String getTitle() {
        return "Threads";
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        private void displayPopupMenu(MouseEvent event) {
            int selectedIndex = this.getSelectionIndex(event);
            if (selectedIndex != -1) {
                TargetProcessThread thread2 = CThreadInformationPanel.this.m_table.getModel().getThreads().get(selectedIndex);
                IDebugger debugger = CThreadInformationPanel.this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
                CThreadInformationTableMenu popupMenu = new CThreadInformationTableMenu(SwingUtilities.getWindowAncestor(CThreadInformationPanel.this), debugger, thread2);
                popupMenu.show(CThreadInformationPanel.this.m_table, event.getX(), event.getY());
            }
        }

        private int getSelectionIndex(MouseEvent event) {
            return CThreadInformationPanel.this.m_table.rowAtPoint(event.getPoint());
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.displayPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.displayPopupMenu(event);
            }
        }
    }
}

