/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.Synchronizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ThreadListener;

public final class CThreadSynchronizer {
    private final ProcessManager m_processManager;
    private final ThreadListener m_threadEventListener;
    private final InternalProcessListener m_internalThreadListener = new InternalProcessListener();

    public CThreadSynchronizer(ProcessManager processManager, ThreadListener threadEventListener) {
        Preconditions.checkNotNull(processManager, "IE01516: Process manager argument can not be null");
        Preconditions.checkNotNull(threadEventListener, "IE01517: Thread event listener argument can not be null");
        this.m_processManager = processManager;
        this.m_threadEventListener = threadEventListener;
        processManager.addListener(this.m_internalThreadListener);
    }

    public void dispose() {
        this.m_processManager.removeListener(this.m_internalThreadListener);
    }

    private class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void addedThread(TargetProcessThread thread2) {
            thread2.addListener(CThreadSynchronizer.this.m_threadEventListener);
        }

        @Override
        public void removedThread(TargetProcessThread thread2) {
            thread2.removeListener(CThreadSynchronizer.this.m_threadEventListener);
        }
    }
}

