/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.Synchronizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.ZyGraph.Painters.CBreakpointPainter;
import com.google.security.zynamics.binnavi.ZyGraph.Painters.CDebuggerPainter;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyNodeRealizerListener;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;

public final class CNodeSynchronizer {
    private final BreakpointManager m_manager;
    private final ZyGraph m_graph;
    private final InternalRealizerListener m_realizerListener = new InternalRealizerListener();
    private final CDebugPerspectiveModel m_debugPerspective;

    public CNodeSynchronizer(BreakpointManager manager, ZyGraph graph, CDebugPerspectiveModel debugPerspective) {
        this.m_graph = Preconditions.checkNotNull(graph, "IE01511: Graph argument can not be null");
        this.m_manager = Preconditions.checkNotNull(manager, "IE01512: Manager argument can not be null");
        this.m_debugPerspective = Preconditions.checkNotNull(debugPerspective, "IE02296: debugPerspective argument can not be null");
        graph.addNodeModifier(this.m_realizerListener);
    }

    private void removeNodeModifier(final IZyNodeRealizerListener<NaviNode> modifier) {
        Preconditions.checkNotNull(modifier, "IE01513: Modifier argument can not be null");
        this.m_graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode node) {
                node.removeNodeModifier(modifier);
                return IterationMode.CONTINUE;
            }
        });
    }

    public void dispose() {
        this.removeNodeModifier(this.m_realizerListener);
    }

    private class InternalRealizerListener
    implements IZyNodeRealizerListener<NaviNode> {
        private InternalRealizerListener() {
        }

        @Override
        public void changedLocation(IZyNodeRealizer realizer, double x2, double y2) {
        }

        @Override
        public void changedSelection(IZyNodeRealizer realizer) {
        }

        @Override
        public void changedSize(IZyNodeRealizer realizer, double x2, double y2) {
        }

        @Override
        public void changedVisibility(IZyNodeRealizer realizer) {
        }

        @Override
        public void regenerated(IZyNodeRealizer realizer) {
            INaviViewNode rawNode;
            TargetProcessThread currentThread;
            IDebugger activeDebugger = CNodeSynchronizer.this.m_debugPerspective.getCurrentSelectedDebugger();
            TargetProcessThread targetProcessThread = currentThread = activeDebugger == null ? null : activeDebugger.getProcessManager().getActiveThread();
            if (currentThread != null) {
                UnrelocatedAddress fileAddress = CNodeSynchronizer.this.m_debugPerspective.getCurrentSelectedDebugger().memoryToFile(currentThread.getCurrentAddress());
                CDebuggerPainter.updateSingleNodeDebuggerHighlighting(CNodeSynchronizer.this.m_graph, fileAddress, (NaviNode)realizer.getUserData().getNode());
            }
            if ((rawNode = (INaviViewNode)((ZyGraphNode)realizer.getUserData().getNode()).getRawNode()) instanceof INaviCodeNode) {
                CBreakpointPainter.paintBreakpoints(CNodeSynchronizer.this.m_manager, (NaviNode)realizer.getUserData().getNode(), (INaviCodeNode)rawNode);
            } else if (rawNode instanceof INaviFunctionNode) {
                CBreakpointPainter.paintBreakpoints(CNodeSynchronizer.this.m_manager, (NaviNode)realizer.getUserData().getNode(), (INaviFunctionNode)rawNode);
            }
        }
    }
}

