/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.Synchronizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.ZyGraph.Painters.CBreakpointPainter;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CBreakpointSynchronizer {
    private final BreakpointManager m_manager;
    private final ZyGraph m_graph;
    private final InternalBreakpointManagerListener m_breakpointManagerListener = new InternalBreakpointManagerListener();

    public CBreakpointSynchronizer(BreakpointManager manager, ZyGraph graph) {
        this.m_manager = Preconditions.checkNotNull(manager, "IE01509: Manager argument can not be null");
        this.m_graph = Preconditions.checkNotNull(graph, "IE01510: Graph argument can not be null");
        manager.addListener(this.m_breakpointManagerListener);
        CBreakpointPainter.paintBreakpoints(manager, this.m_graph);
    }

    public void dispose() {
        this.m_manager.removeListener(this.m_breakpointManagerListener);
    }

    private class InternalBreakpointManagerListener
    extends BreakpointManagerListenerAdapter {
        private InternalBreakpointManagerListener() {
        }

        @Override
        public void breakpointsAdded(List<Breakpoint> breakpoints) {
            Preconditions.checkNotNull(breakpoints, "IE00735: breakpoints argument can not be null");
            for (Breakpoint breakpoint : breakpoints) {
                if (breakpoint.getType() != BreakpointType.REGULAR) continue;
                CBreakpointPainter.paintBreakpoints(CBreakpointSynchronizer.this.m_manager, CBreakpointSynchronizer.this.m_graph, breakpoint.getAddress());
            }
        }

        @Override
        public void breakpointsRemoved(Set<Breakpoint> breakpoints) {
            Preconditions.checkNotNull(breakpoints, "IE00736: breakpoints argument can not be null");
            for (Breakpoint breakpoint : breakpoints) {
                if (breakpoint.getType() != BreakpointType.REGULAR) continue;
                CBreakpointPainter.paintBreakpoints(CBreakpointSynchronizer.this.m_manager, CBreakpointSynchronizer.this.m_graph, breakpoint.getAddress());
            }
        }

        @Override
        public void breakpointsStatusChanged(Map<Breakpoint, BreakpointStatus> breakpointsToOldStatus, BreakpointStatus newStatus) {
            Preconditions.checkNotNull(breakpointsToOldStatus, "IE01002: breakpoints argument can not be null");
            Preconditions.checkNotNull(newStatus, "IE01006: newStatus argument can not be null");
            for (Breakpoint breakpoint : breakpointsToOldStatus.keySet()) {
                if (breakpoint.getType() != BreakpointType.REGULAR) continue;
                CBreakpointPainter.paintBreakpoints(CBreakpointSynchronizer.this.m_manager, CBreakpointSynchronizer.this.m_graph, breakpoint.getAddress());
            }
        }
    }
}

