/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.StatusLabel;

import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import javax.swing.JLabel;

public class CProcessListener
extends ProcessManagerListenerAdapter {
    private final JLabel m_label;

    public CProcessListener(JLabel label) {
        this.m_label = label;
    }

    private static String createExceptionMessage(DebuggerException exception) {
        String string2 = String.valueOf(exception.getExceptionName().isEmpty() ? String.format("Exception code: 0x%X", exception.getExceptionCode()) : String.format("Exception name: %s, exception code: 0x%X", exception.getExceptionName(), exception.getExceptionCode()));
        return string2.length() != 0 ? "An exception occurred in the target process. ".concat(string2) : new String("An exception occurred in the target process. ");
    }

    @Override
    public void addedModule(MemoryModule module) {
        this.m_label.setText(String.format("Loaded module %s at base address %s", module.getName(), module.getBaseAddress().getAddress().toHexString()));
    }

    @Override
    public void attached() {
        this.m_label.setText("Successfully attached to the target process");
    }

    @Override
    public void detached() {
        this.m_label.setText("Detached from the target process");
    }

    @Override
    public void raisedException(DebuggerException exception) {
        this.m_label.setText(CProcessListener.createExceptionMessage(exception));
    }

    @Override
    public void removedModule(MemoryModule module) {
        this.m_label.setText(String.format("Unloaded module %s from base address %s", module.getName(), module.getBaseAddress().getAddress().toHexString()));
    }

    @Override
    public void removedNonExistingModule(MemoryModule module) {
        this.m_label.setText(String.format("Unloaded unknown module from base address %s", module.getBaseAddress().getAddress().toHexString()));
    }
}

