/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.StackPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.StackPanel.CStackMemoryProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ThreadListener;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import com.google.security.zynamics.zylib.gui.JStackView.JStackView;

public final class CStackViewSynchronizer {
    private final JStackView m_stackView;
    private final CStackMemoryProvider m_model;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final IDebugPerspectiveModelListener m_listener = new InternalPerspectiveListener();
    private final ProcessManagerListener m_processListener = new ProcessManagerListenerAdapter(){

        @Override
        public void changedActiveThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
            CStackViewSynchronizer.this.synchronizeThread(oldThread, newThread);
            CStackViewSynchronizer.this.updateGui();
        }
    };
    private final ThreadListener m_threadListener = new InternalThreadListener();

    public CStackViewSynchronizer(JStackView stackView, CStackMemoryProvider model, CDebugPerspectiveModel debugPerspectiveModel) {
        Preconditions.checkNotNull(stackView, "IE01506: Stack view argument can not be null");
        Preconditions.checkNotNull(model, "IE01507: Model argument can not be null");
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01508: Debug perspective model argument can not be null");
        this.m_stackView = stackView;
        this.m_model = model;
        this.m_debugPerspectiveModel = debugPerspectiveModel;
        this.m_debugPerspectiveModel.addListener(this.m_listener);
        this.synchronizeDebuggers(null, this.m_debugPerspectiveModel.getCurrentSelectedDebugger());
    }

    private long getStackPointer(TargetProcessThread activeThread) {
        for (RegisterValue registerValue : activeThread.getRegisterValues()) {
            if (!registerValue.isSp()) continue;
            return registerValue.getValue().longValue();
        }
        return 0L;
    }

    private void synchronizeDebuggers(IDebugger oldDebugger, IDebugger newDebugger) {
        TargetProcessThread activeThread;
        if (oldDebugger != null) {
            oldDebugger.getProcessManager().removeListener(this.m_processListener);
            activeThread = oldDebugger.getProcessManager().getActiveThread();
            this.synchronizeThread(activeThread, null);
        }
        if (newDebugger != null) {
            newDebugger.getProcessManager().addListener(this.m_processListener);
            activeThread = newDebugger.getProcessManager().getActiveThread();
            this.synchronizeThread(null, activeThread);
        }
    }

    private void synchronizeThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
        if (oldThread != null) {
            oldThread.removeListener(this.m_threadListener);
        }
        if (newThread != null) {
            newThread.addListener(this.m_threadListener);
        }
        this.m_model.setActiveThread(newThread);
    }

    private void updateGui() {
        TargetProcessThread activeThread;
        IDebugger activeDebugger = this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
        TargetProcessThread targetProcessThread = activeThread = activeDebugger == null ? null : activeDebugger.getProcessManager().getActiveThread();
        if (activeThread == null) {
            this.m_stackView.setDefinitionStatus(JHexView.DefinitionStatus.UNDEFINED);
            this.m_stackView.setEnabled(false);
        } else {
            this.m_stackView.setDefinitionStatus(JHexView.DefinitionStatus.DEFINED);
            this.m_stackView.setEnabled(true);
            this.m_stackView.gotoOffset(this.getStackPointer(activeThread));
        }
    }

    public void dispose() {
        this.m_debugPerspectiveModel.removeListener(this.m_listener);
        this.synchronizeDebuggers(this.m_debugPerspectiveModel.getCurrentSelectedDebugger(), null);
    }

    private class InternalThreadListener
    extends ThreadListenerAdapter {
        private InternalThreadListener() {
        }

        @Override
        public void registersChanged(TargetProcessThread thread2) {
            CStackViewSynchronizer.this.updateGui();
        }
    }

    private class InternalPerspectiveListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalPerspectiveListener() {
        }

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            CStackViewSynchronizer.this.m_model.setDebugger(newDebugger);
            CStackViewSynchronizer.this.synchronizeDebuggers(oldDebugger, newDebugger);
            CStackViewSynchronizer.this.updateGui();
        }
    }
}

