/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.StackPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.StackPanel.CStackMemoryProvider;
import com.google.security.zynamics.binnavi.Gui.Debug.StackPanel.CStackViewMenu;
import com.google.security.zynamics.binnavi.Gui.Debug.StackPanel.CStackViewSynchronizer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.zylib.gui.JStackView.JStackView;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public final class CStackView
extends JPanel {
    private static final long serialVersionUID = -3557489956883932908L;
    private final JStackView m_stackView;
    private final CStackMemoryProvider m_model = new CStackMemoryProvider();
    private final CStackViewSynchronizer m_synchronizer;

    public CStackView(CDebugPerspectiveModel debugPerspectiveModel) {
        super(new BorderLayout());
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01503: Debug perspective model argument can not be null");
        this.setBorder(new TitledBorder("Stack"));
        this.m_model.setDebugger(debugPerspectiveModel.getCurrentSelectedDebugger());
        this.m_stackView = new JStackView(this.m_model);
        this.m_stackView.addMouseListener(new InternalMouseListener());
        this.add(this.m_stackView);
        this.m_synchronizer = new CStackViewSynchronizer(this.m_stackView, this.m_model, debugPerspectiveModel);
    }

    private void showPopupMenu(MouseEvent event) {
        CStackViewMenu menu = new CStackViewMenu(this.m_stackView, this.m_model, event.getPoint());
        menu.show(this, event.getX(), event.getY());
    }

    public void dispose() {
        this.m_synchronizer.dispose();
    }

    public CStackMemoryProvider getStackProvider() {
        return this.m_model;
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CStackView.this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CStackView.this.showPopupMenu(event);
            }
        }
    }
}

