/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.StackPanel;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.Debug.StackPanel.StackDataLayout;
import com.google.security.zynamics.binnavi.debug.debugger.MemoryRangeCalculator;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IMemoryProvider;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ByteHelpers;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.memmanager.IMemoryListener;
import com.google.security.zynamics.zylib.gui.JStackView.AddressMode;
import com.google.security.zynamics.zylib.gui.JStackView.IStackModel;
import com.google.security.zynamics.zylib.gui.JStackView.IStackModelListener;
import java.math.BigInteger;

public final class CStackMemoryProvider
implements IStackModel {
    private IDebugger m_debugger;
    private IMemoryProvider m_memoryProvider;
    private TargetProcessThread m_activeThread;
    private final ListenerProvider<IStackModelListener> m_listeners = new ListenerProvider();
    private final InternalMemoryListener m_listener = new InternalMemoryListener();
    private final InternalProcessListener m_internalProcessListener = new InternalProcessListener();
    private StackDataLayout m_dataLayout = StackDataLayout.Bytes;
    private AddressMode m_addressMode = AddressMode.BIT32;

    private static BigInteger getStackValue(ImmutableList<RegisterValue> registers) {
        for (RegisterValue registerValue : registers) {
            if (!registerValue.isSp()) continue;
            return registerValue.getValue();
        }
        return null;
    }

    private void notifyListeners() {
        for (IStackModelListener listener : this.m_listeners) {
            try {
                listener.dataChanged();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void addListener(IStackModelListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public String getElement(long address) {
        if (this.m_dataLayout == StackDataLayout.Bytes) {
            if (this.m_addressMode == AddressMode.BIT32) {
                String unpaddedValue = BigInteger.valueOf(ByteHelpers.readDwordBigEndian(this.m_debugger.getProcessManager().getMemory().getData(address, 4), 0)).toString(16);
                return Strings.padStart(unpaddedValue, 8, '0').toUpperCase();
            }
            if (this.m_addressMode == AddressMode.BIT64) {
                String unpaddedValue = BigInteger.valueOf(ByteHelpers.readQwordBigEndian(this.m_debugger.getProcessManager().getMemory().getData(address, 8), 0)).toString(16);
                return Strings.padStart(unpaddedValue, 16, '0').toUpperCase();
            }
            throw new IllegalStateException("IE01137: Unknown address mode");
        }
        if (this.m_dataLayout == StackDataLayout.Dwords) {
            if (this.m_addressMode == AddressMode.BIT32) {
                String unpaddedValue = BigInteger.valueOf(ByteHelpers.readDwordLittleEndian(this.m_debugger.getProcessManager().getMemory().getData(address, 4), 0)).toString(16);
                return Strings.padStart(unpaddedValue, 8, '0').toUpperCase();
            }
            if (this.m_addressMode == AddressMode.BIT64) {
                String unpaddedValue = BigInteger.valueOf(ByteHelpers.readQwordLittleEndian(this.m_debugger.getProcessManager().getMemory().getData(address, 8), 0)).toString(16);
                return Strings.padStart(unpaddedValue, 16, '0').toUpperCase();
            }
            throw new IllegalStateException("IE01138: Unknown address mode");
        }
        throw new IllegalStateException("IE01139: Invalid data layout selected");
    }

    @Override
    public int getNumberOfEntries() {
        if (this.m_activeThread == null || this.m_debugger == null) {
            return 0;
        }
        BigInteger stackValue = CStackMemoryProvider.getStackValue(this.m_activeThread.getRegisterValues());
        if (stackValue == null) {
            return 0;
        }
        MemorySection section = this.m_debugger.getProcessManager().getMemoryMap().findOffset(stackValue);
        if (section == null) {
            if (this.m_debugger.isConnected()) {
                return this.m_debugger.getProcessManager().getTargetInformation().getDebuggerOptions().getPageSize();
            }
            return 0;
        }
        return (int)((section.getEnd().toLong() - section.getStart().toLong()) / 4L);
    }

    @Override
    public long getStackPointer() {
        if (this.m_activeThread == null) {
            return -1L;
        }
        BigInteger stackValue = CStackMemoryProvider.getStackValue(this.m_activeThread.getRegisterValues());
        if (stackValue == null) {
            return -1L;
        }
        return stackValue.longValue();
    }

    @Override
    public long getStartAddress() {
        if (this.m_activeThread == null || this.m_activeThread.getRegisterValues().size() == 0 || this.m_debugger == null) {
            return -1L;
        }
        BigInteger stackValue = CStackMemoryProvider.getStackValue(this.m_activeThread.getRegisterValues());
        if (stackValue == null) {
            return -1L;
        }
        MemorySection section = this.m_debugger.getProcessManager().getMemoryMap().findOffset(stackValue);
        if (section == null) {
            if (this.m_debugger.isConnected()) {
                return stackValue.and(BigInteger.valueOf(-4096L)).longValue();
            }
            return -1L;
        }
        return section.getStart().toLong();
    }

    @Override
    public boolean hasData(long startAddress, long numberOfBytes) {
        if (this.m_debugger == null) {
            return false;
        }
        if (this.m_debugger.getProcessManager().getTargetInformation().getDebuggerOptions().canMemmap()) {
            return this.m_memoryProvider != null && this.m_memoryProvider.hasData(BigInteger.valueOf(startAddress), (int)numberOfBytes);
        }
        CAddress stackStart = new CAddress(this.getStartAddress());
        int stackSize = this.getNumberOfEntries() * 4;
        CAddress stackEnd = new CAddress(this.getStartAddress() + (long)stackSize);
        Pair<IAddress, Integer> realRange = MemoryRangeCalculator.calculateRequestRange(BigInteger.valueOf(startAddress), (int)numberOfBytes, stackStart, stackEnd);
        long realStart = realRange.first().toLong();
        long realSize = realRange.second().intValue();
        return this.m_memoryProvider != null && this.m_memoryProvider.hasData(BigInteger.valueOf(startAddress), (int)numberOfBytes, BigInteger.valueOf(realStart), (int)realSize);
    }

    @Override
    public boolean keepTrying() {
        return this.m_debugger != null && this.m_debugger.isConnected();
    }

    public void setActiveThread(TargetProcessThread activeThread) {
        this.m_activeThread = activeThread;
        this.notifyListeners();
    }

    public void setAddressMode(AddressMode addressMode) {
        Preconditions.checkNotNull(addressMode, "IE01501: Address mode argument can not be null");
        if (addressMode == this.m_addressMode) {
            return;
        }
        this.m_addressMode = addressMode;
        this.notifyListeners();
    }

    public void setDataLayout(StackDataLayout dataLayout) {
        Preconditions.checkNotNull(dataLayout, "IE01502: Layout argument can not be null");
        this.m_dataLayout = dataLayout;
        this.notifyListeners();
    }

    public void setDebugger(IDebugger debugger) {
        if (this.m_debugger != null) {
            this.m_debugger.getProcessManager().getMemory().removeMemoryListener(this.m_listener);
            this.m_debugger.getProcessManager().removeListener(this.m_internalProcessListener);
        }
        this.m_debugger = debugger;
        IMemoryProvider iMemoryProvider = this.m_memoryProvider = debugger == null ? null : debugger.getMemoryProvider();
        if (debugger != null) {
            this.m_debugger.getProcessManager().getMemory().addMemoryListener(this.m_listener);
            this.m_debugger.getProcessManager().addListener(this.m_internalProcessListener);
        }
        this.notifyListeners();
    }

    private class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void detached() {
            CStackMemoryProvider.this.setActiveThread(null);
        }
    }

    private class InternalMemoryListener
    implements IMemoryListener {
        private InternalMemoryListener() {
        }

        @Override
        public void memoryChanged(long address, int size) {
            CStackMemoryProvider.this.notifyListeners();
        }

        @Override
        public void memoryCleared() {
            CStackMemoryProvider.this.notifyListeners();
        }
    }
}

