/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.SearchMemory;

import com.google.security.zynamics.binnavi.Gui.Debug.SearchMemory.AsciiSearcher;
import com.google.security.zynamics.binnavi.Gui.Debug.SearchMemory.HexSearcher;
import com.google.security.zynamics.binnavi.Gui.Debug.SearchMemory.ISearcher;
import com.google.security.zynamics.binnavi.Gui.Debug.SearchMemory.UnicodeSearcher;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class CSearchDialog
extends JDialog {
    private static final long serialVersionUID = -2835590563881465026L;
    private JComboBox<ISearcher> m_typeBox;
    private final JTextField m_altField = new JTextField();
    private JFormattedTextField m_inputField;
    private JLabel m_otherLabel;
    private byte[] m_searchData;

    public CSearchDialog(Window parent) {
        super(parent, "Find", Dialog.ModalityType.DOCUMENT_MODAL);
        new CDialogEscaper(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createSearchPane(), "Center");
        this.add((Component)new CPanelTwoButtons(new InternalActionListener(), "OK", "Cancel"), "South");
        this.pack();
        GuiHelper.centerChildToParent(parent, this, true);
        this.setVisible(true);
    }

    private JPanel createSearchPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(3, 2));
        panel.setBorder(new TitledBorder("Search for ..."));
        panel.add(new JLabel("Type"));
        this.m_typeBox = new JComboBox();
        this.m_typeBox.addItem(new AsciiSearcher());
        this.m_typeBox.addItem(new UnicodeSearcher());
        this.m_typeBox.addItem(new HexSearcher());
        this.m_typeBox.setSelectedIndex(0);
        this.m_typeBox.addActionListener(new InternalTypeListener());
        panel.add(this.m_typeBox);
        panel.add(new JLabel("Value"));
        this.m_inputField = new JFormattedTextField();
        this.m_inputField.getDocument().addDocumentListener(new InternalTextListener());
        panel.add(this.m_inputField);
        this.m_otherLabel = new JLabel("Hex");
        panel.add(this.m_otherLabel);
        this.m_altField.setEnabled(false);
        panel.add(this.m_altField);
        panel.setSize(500, 300);
        return panel;
    }

    private void prepareData() {
        ISearcher searcher = (ISearcher)this.m_typeBox.getSelectedItem();
        if (searcher != null) {
            this.m_searchData = searcher.getSearchData(this.m_inputField.getText());
        }
    }

    private void updateAlternativeField() {
        ISearcher searcher = (ISearcher)this.m_typeBox.getSelectedItem();
        if (searcher != null) {
            this.m_altField.setText(searcher.getAlternativeString(this.m_inputField.getText()));
        }
    }

    public byte[] getSearchData() {
        return this.m_searchData;
    }

    private class InternalTypeListener
    implements ActionListener {
        private InternalTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ISearcher searcher = (ISearcher)CSearchDialog.this.m_typeBox.getSelectedItem();
            if (searcher != null) {
                CSearchDialog.this.m_inputField.setFormatterFactory(searcher.getFormatterFactory());
                CSearchDialog.this.m_otherLabel.setText(searcher.getAlternativeName());
                CSearchDialog.this.updateAlternativeField();
            }
        }
    }

    private class InternalTextListener
    implements DocumentListener {
        private InternalTextListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            CSearchDialog.this.updateAlternativeField();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            CSearchDialog.this.updateAlternativeField();
        }
    }

    private class InternalActionListener
    implements ActionListener {
        private InternalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("OK")) {
                CSearchDialog.this.prepareData();
            }
            CSearchDialog.this.dispose();
        }
    }
}

