/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.FileBrowser;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.FileBrowser.CRemoteBrowserHelpers;
import com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.FileBrowser.CRemoteFile;
import com.google.security.zynamics.binnavi.debug.models.remotebrowser.RemoteDirectory;
import com.google.security.zynamics.binnavi.debug.models.remotebrowser.RemoteDrive;
import com.google.security.zynamics.binnavi.debug.models.remotebrowser.RemoteFile;
import com.google.security.zynamics.binnavi.debug.models.remotebrowser.RemoteFileSystem;
import com.google.security.zynamics.zylib.io.FileUtils;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionMapper;
import java.io.File;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public final class CRemoteFileSystemView
extends FileSystemView {
    private final CRemoteFile m_defaultDirectory;
    private RemoteFileSystem m_fileSystem;

    public CRemoteFileSystemView(RemoteFileSystem fileSystem) {
        Preconditions.checkNotNull(fileSystem, "IE01496: File system argument can not be null");
        this.m_fileSystem = fileSystem;
        this.m_defaultDirectory = new CRemoteFile(fileSystem.getDirectory().getName(), true);
    }

    @Override
    public File createNewFolder(File containingDir) {
        return null;
    }

    @Override
    public File getDefaultDirectory() {
        return this.m_defaultDirectory;
    }

    @Override
    public File[] getFiles(File dir, boolean useFileHiding) {
        CRemoteFile[] files = CollectionHelpers.map(this.m_fileSystem.getFiles(), new ICollectionMapper<RemoteFile, File>(){

            @Override
            public File map(RemoteFile item) {
                String string2 = CRemoteFileSystemView.this.m_fileSystem.getDirectory().getName();
                String string3 = item.getName();
                return new CRemoteFile(new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("/").append(string3).toString(), false);
            }
        }).toArray(new CRemoteFile[0]);
        CRemoteFile[] directories = CollectionHelpers.map(this.m_fileSystem.getDirectories(), new ICollectionMapper<RemoteDirectory, File>(){

            @Override
            public File map(RemoteDirectory item) {
                String string2 = CRemoteFileSystemView.this.m_fileSystem.getDirectory().getName();
                String string3 = item.getName();
                return new CRemoteFile(new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("/").append(string3).append("/").toString(), true);
            }
        }).toArray(new CRemoteFile[0]);
        File[] combined = new File[files.length + directories.length];
        System.arraycopy(files, 0, combined, 0, files.length);
        System.arraycopy(directories, 0, combined, files.length, directories.length);
        return combined;
    }

    @Override
    public File getHomeDirectory() {
        return this.m_defaultDirectory;
    }

    @Override
    public File getParentDirectory(File dir) {
        return new CRemoteFile(dir.getParent(), true);
    }

    @Override
    public File[] getRoots() {
        return CollectionHelpers.map(this.m_fileSystem.getDrives(), new ICollectionMapper<RemoteDrive, File>(){

            @Override
            public File map(RemoteDrive item) {
                return new CRemoteFile(String.valueOf(item.getName()).concat("/"), true);
            }
        }).toArray(new CRemoteFile[0]);
    }

    @Override
    public String getSystemDisplayName(File file) {
        return this.isDrive(file) ? file.getAbsolutePath() : FileUtils.getFileBasename(file);
    }

    @Override
    public Icon getSystemIcon(File file) {
        throw new IllegalStateException("IE01132: Not yet implemented");
    }

    @Override
    public String getSystemTypeDescription(File file) {
        throw new IllegalStateException("IE01133: Not yet implemented");
    }

    @Override
    public boolean isComputerNode(File dir) {
        return false;
    }

    @Override
    public boolean isDrive(File dir) {
        return CRemoteBrowserHelpers.isDrive(dir);
    }

    @Override
    public boolean isFileSystem(File file) {
        throw new IllegalStateException("IE01134: Not yet implemented");
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        return false;
    }

    @Override
    public boolean isFloppyDrive(File dir) {
        return false;
    }

    @Override
    public boolean isHiddenFile(File file) {
        throw new IllegalStateException("IE01135: Not yet implemented");
    }

    @Override
    public boolean isParent(File folder, File file) {
        return false;
    }

    @Override
    public boolean isRoot(File file) {
        return file != null && this.isDrive(file);
    }

    public void setFileSystem(RemoteFileSystem fileSystem) {
        Preconditions.checkNotNull(fileSystem, "IE01497: File system argument can not be null");
        this.m_fileSystem = fileSystem;
    }
}

