/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.RelocationDialog;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.Collection;
import javax.swing.table.AbstractTableModel;

public final class CRelocationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -5994931123546374970L;
    private static final String[] COLUMN_NAMES = new String[]{"Module", "Specified Image Base", "Real Image Base"};
    public static final int NAME_COLUMN = 0;
    public static final int SPECIFIED_COLUMN = 1;
    public static final int REAL_COLUMN = 2;
    private final IDebugger m_debugger;
    private final IFilledList<Pair<INaviModule, MemoryModule>> m_wronglyPlacedModules;

    public CRelocationTableModel(IDebugger debugger, IFilledList<Pair<INaviModule, MemoryModule>> wronglyPlacedModules) {
        Preconditions.checkNotNull(debugger, "IE01487: Debugger argument can not be null");
        Preconditions.checkNotNull(wronglyPlacedModules, "IE01488: Wrongly placed modules argument can not be null");
        this.m_debugger = debugger;
        this.m_wronglyPlacedModules = new FilledList<Pair<INaviModule, MemoryModule>>((Collection<Pair<INaviModule, MemoryModule>>)wronglyPlacedModules);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getRowCount() {
        return this.m_wronglyPlacedModules.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Pair pair = (Pair)this.m_wronglyPlacedModules.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return ((INaviModule)pair.first()).getConfiguration().getName();
            }
            case 1: {
                return this.m_debugger.fileToMemory((INaviModule)pair.first(), new UnrelocatedAddress(((INaviModule)pair.first()).getConfiguration().getFileBase())).getAddress().toHexString();
            }
            case 2: {
                return ((MemoryModule)pair.second()).getBaseAddress().getAddress().toHexString();
            }
        }
        throw new IllegalStateException("IE01126: Unknown column");
    }
}

