/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel.CRegisterMenuProvider;
import com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel.CRegisterProvider;
import com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel.CRegisterViewSynchronizer;
import com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel.IDataEnteredListener;
import com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel.Implementations.CRegisterFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.zylib.gui.JRegisterView.JRegisterView;
import java.awt.BorderLayout;
import java.math.BigInteger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public final class CRegisterView
extends JPanel {
    private static final long serialVersionUID = 1272866008900112960L;
    private final JFrame m_parent;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final JRegisterView m_registerView;
    private final CRegisterProvider m_dataProvider = new CRegisterProvider();
    private final CRegisterViewSynchronizer m_synchronizer;
    private final InternalDataEnteredListener m_enteredDataListener = new InternalDataEnteredListener();

    public CRegisterView(JFrame parent, CDebugPerspectiveModel debugPerspectiveModel) {
        super(new BorderLayout());
        Preconditions.checkNotNull(parent, "IE01477: Parent argument can not be null");
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01478: Debug perspective model argument can not be null");
        this.m_parent = parent;
        this.m_debugPerspectiveModel = debugPerspectiveModel;
        this.setBorder(new TitledBorder("Register Values"));
        this.m_dataProvider.addListener(this.m_enteredDataListener);
        this.m_registerView = new JRegisterView(this.m_dataProvider);
        this.m_registerView.setVisible(true);
        this.m_registerView.setMenuProvider(new CRegisterMenuProvider(debugPerspectiveModel, this.m_dataProvider));
        JScrollPane regScroller = new JScrollPane(this.m_registerView);
        regScroller.getViewport().setBackground(this.m_registerView.getBackground());
        regScroller.setVerticalScrollBarPolicy(22);
        this.add(regScroller);
        this.m_synchronizer = new CRegisterViewSynchronizer(this.m_registerView, this.m_dataProvider, debugPerspectiveModel);
    }

    public void dispose() {
        this.m_synchronizer.dispose();
        this.m_registerView.dispose();
    }

    private class InternalDataEnteredListener
    implements IDataEnteredListener {
        private InternalDataEnteredListener() {
        }

        @Override
        public void registerChanged(int index, BigInteger oldValue, BigInteger newValue) {
            TargetProcessThread activeThread;
            IDebugger debugger = CRegisterView.this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
            TargetProcessThread targetProcessThread = activeThread = debugger == null ? null : debugger.getProcessManager().getActiveThread();
            if (debugger != null && activeThread != null) {
                CRegisterFunctions.changeRegister(CRegisterView.this.m_parent, debugger, CRegisterView.this.m_registerView, activeThread.getThreadId(), index, newValue);
            }
        }
    }
}

