/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.OptionsPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.Debug.OptionsPanel.Actions.CShowOptionsDialogAction;
import com.google.security.zynamics.binnavi.Gui.Debug.OptionsPanel.CRelocationCheckBox;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.DebugTargetSettings;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public final class COptionsPanel
extends JPanel {
    private static final long serialVersionUID = 212662840552542949L;
    private final JFrame m_parent;
    private final DebugTargetSettings m_debugTarget;
    private final ZyGraph m_graph;
    private final IDebugPerspectiveModelListener m_listener = new InternalDebuggerListener();

    public COptionsPanel(JFrame parent, DebugTargetSettings debugTarget, ZyGraph graph, CDebugPerspectiveModel debugModel) {
        super(new BorderLayout());
        Preconditions.checkNotNull(graph, "IE01468: Graph argument can not be null");
        this.m_parent = parent;
        this.m_debugTarget = debugTarget;
        this.m_graph = graph;
        this.setBorder(new TitledBorder("Debugger Options"));
        this.setDebugger(debugModel.getCurrentSelectedDebugger());
        debugModel.addListener(this.m_listener);
        this.setPreferredSize(new Dimension(200, 300));
    }

    private void setDebugger(IDebugger debugger) {
        this.removeAll();
        if (debugger != null) {
            JPanel innerOptionsPanel = new JPanel(new GridLayout(1, 1));
            innerOptionsPanel.add(new CRelocationCheckBox(this.m_graph, debugger));
            this.add((Component)innerOptionsPanel, "North");
            JButton showButton = new JButton(CActionProxy.proxy(new CShowOptionsDialogAction(this.m_parent, this.m_debugTarget, debugger)));
            this.add((Component)showButton, "South");
        }
    }

    private class InternalDebuggerListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalDebuggerListener() {
        }

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            COptionsPanel.this.setDebugger(newDebugger);
        }
    }
}

