/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.OptionsDialog;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.OptionsDialog.CDebuggerEventSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.Debug.OptionsDialog.CExceptionSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.Debug.OptionsDialog.COptionsPanel;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerEventSettings;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerOptions;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class COptionsDialog
extends JDialog {
    private static final long serialVersionUID = 8410779795049480922L;
    private final CExceptionSettingsPanel m_exceptionSettingsPanel;
    private final CDebuggerEventSettingsPanel m_debuggerEventSettingsPanel;
    private final DebuggerOptions m_options;

    public COptionsDialog(JFrame parent, DebuggerOptions options, DebuggerEventSettings eventSettings) {
        super(parent, "Available Debugger Options", true);
        Preconditions.checkNotNull(parent, "IE01466: Parent argument can not be null");
        Preconditions.checkNotNull(options, "IE01467: Options argument can not be null");
        this.m_options = DebuggerOptions.newInstance(options);
        this.setLayout(new BorderLayout());
        this.m_exceptionSettingsPanel = new CExceptionSettingsPanel(this.m_options);
        this.m_debuggerEventSettingsPanel = new CDebuggerEventSettingsPanel(eventSettings);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)new COptionsPanel(this.m_options), "Debug Options");
        tabbedPane.add((Component)this.m_exceptionSettingsPanel, "Exception Options");
        tabbedPane.add((Component)this.m_debuggerEventSettingsPanel, "Debugger Event Settings");
        this.add(tabbedPane);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JButton okButton = new JButton(new AbstractAction("OK"){
            private static final long serialVersionUID = -2448050114927136382L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                COptionsDialog.this.setVisible(false);
            }
        });
        okButton.setPreferredSize(new Dimension(100, 25));
        buttonPanel.add((Component)okButton, "East");
        this.add((Component)buttonPanel, "South");
        new CDialogEscaper(this);
        this.setSize(600, 400);
        this.setLocationRelativeTo(null);
    }

    public DebuggerEventSettings getDebuggerEventSettings() {
        return this.m_debuggerEventSettingsPanel.getSettings();
    }

    public DebuggerOptions getDebuggerOptions() {
        this.m_options.setExceptions(this.m_exceptionSettingsPanel.getExceptionSettings());
        return this.m_options;
    }
}

