/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.Notifier;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public final class CRelocationNotifier {
    private CRelocationNotifier() {
    }

    private static List<Pair<INaviModule, MemoryModule>> collectWronglyPlacedModules(IDebugger debugger, IViewContainer viewContainer, List<MemoryModule> memoryModules) {
        ArrayList<Pair<INaviModule, MemoryModule>> wronglyPlacedModules = new ArrayList<Pair<INaviModule, MemoryModule>>();
        List<INaviModule> modules = viewContainer.getModules();
        for (INaviModule module : modules) {
            for (MemoryModule memoryModule : memoryModules) {
                if (!module.getConfiguration().getName().equalsIgnoreCase(memoryModule.getName())) continue;
                RelocatedAddress assumedAddress = debugger.fileToMemory(module, new UnrelocatedAddress(module.getConfiguration().getFileBase()));
                IAddress memoryAddress = memoryModule.getBaseAddress().getAddress();
                if (assumedAddress.getAddress().equals(memoryAddress)) continue;
                wronglyPlacedModules.add(new Pair<INaviModule, MemoryModule>(module, memoryModule));
            }
        }
        return wronglyPlacedModules;
    }

    public static void checkBaseAddresses(JFrame parent, IDebugger debugger, IViewContainer viewContainer, List<MemoryModule> memoryModules) {
        List<Pair<INaviModule, MemoryModule>> wronglyPlacedModules = CRelocationNotifier.collectWronglyPlacedModules(debugger, viewContainer, memoryModules);
        if (!wronglyPlacedModules.isEmpty()) {
            for (Pair<INaviModule, MemoryModule> pair : wronglyPlacedModules) {
                INaviModule module = pair.first();
                MemoryModule memoryModule = pair.second();
                List<INaviAddressSpace> addressSpaces = viewContainer.getAddressSpaces();
                if (addressSpaces == null) {
                    try {
                        module.getConfiguration().setImageBase(memoryModule.getBaseAddress().getAddress());
                    }
                    catch (CouldntSaveDataException e2) {
                        CUtilityFunctions.logException(e2);
                    }
                    continue;
                }
                for (INaviAddressSpace addressSpace : addressSpaces) {
                    if (!addressSpace.getContent().getModules().contains(module)) continue;
                    try {
                        addressSpace.getContent().setImageBase(module, memoryModule.getBaseAddress().getAddress());
                    }
                    catch (CouldntSaveDataException e3) {
                        CUtilityFunctions.logException(e3);
                    }
                }
            }
        }
    }

    public static void relocateModule(IDebugger debugger, MemoryModule memoryModule) {
        for (INaviModule module : debugger.getModules()) {
            RelocatedAddress assumedAddress;
            if (!module.getConfiguration().getName().equalsIgnoreCase(memoryModule.getName()) || (assumedAddress = debugger.fileToMemory(module, new UnrelocatedAddress(module.getConfiguration().getFileBase()))).getAddress().equals(memoryModule.getBaseAddress().getAddress())) continue;
            try {
                module.getConfiguration().setImageBase(memoryModule.getBaseAddress().getAddress());
            }
            catch (CouldntSaveDataException exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

