/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.Notifier;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphContainerWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import com.google.security.zynamics.binnavi.Gui.WindowManager.CWindowManager;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.CViewHelpers;
import java.util.ArrayList;
import java.util.List;

public final class CPanelFinder {
    private CPanelFinder() {
    }

    private static List<IGraphPanel> collectPanelsWithAddress(IDebugger debugger, UnrelocatedAddress address) {
        ArrayList<IGraphPanel> panels = new ArrayList<IGraphPanel>();
        for (IGraphContainerWindow iGraphContainerWindow : CWindowManager.instance().getOpenWindows()) {
            for (IGraphPanel graphPanel : iGraphContainerWindow) {
                BackEndDebuggerProvider debuggerProvider = graphPanel.getModel().getDebuggerProvider();
                for (IDebugger d2 : debuggerProvider) {
                    if (d2 != debugger || !CViewHelpers.containsAddress(graphPanel.getModel().getGraph().getRawView(), address)) continue;
                    panels.add(graphPanel);
                }
            }
        }
        return panels;
    }

    public static IGraphPanel getPanelWithAddress(IDebugger debugger, UnrelocatedAddress address) {
        List<IGraphPanel> panels = CPanelFinder.collectPanelsWithAddress(debugger, address);
        if (panels.isEmpty()) {
            return null;
        }
        ArrayList<IGraphPanel> activeWindowPanels = new ArrayList<IGraphPanel>();
        ArrayList<IGraphPanel> inactiveWindowPanels = new ArrayList<IGraphPanel>();
        for (IGraphPanel panel : panels) {
            CGraphWindow parent = panel.getModel().getParent();
            if (parent.isActive() && parent.isActiveGraph(panel)) {
                return panel;
            }
            if (parent.isActive()) {
                activeWindowPanels.add(panel);
                continue;
            }
            inactiveWindowPanels.add(panel);
        }
        if (activeWindowPanels.isEmpty()) {
            return (IGraphPanel)inactiveWindowPanels.get(0);
        }
        return (IGraphPanel)activeWindowPanels.get(0);
    }
}

