/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.Notifier;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointRemovalNotification.CBreakpointRemovalDialog;
import com.google.security.zynamics.binnavi.Gui.Debug.GraphSelectionDialog.CGraphSelectionDialog;
import com.google.security.zynamics.binnavi.Gui.Debug.Notifier.CPanelFinder;
import com.google.security.zynamics.binnavi.Gui.Debug.Notifier.CRelocationNotifier;
import com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.Loader.CRemoteFileBrowserLoader;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations.CDebuggerFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphContainerWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import com.google.security.zynamics.binnavi.Gui.Loaders.CViewOpener;
import com.google.security.zynamics.binnavi.Gui.WindowManager.CWindowManager;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.Settings.CGlobalSettings;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.AnyBreakpointRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.AttachReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.AuthenticationFailedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointConditionSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DetachReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.HaltReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.MemoryMapReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ProcessClosedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.QueryDebuggerEventSettingsReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ReadMemoryReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.RegistersReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.RequestTargetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SetExceptionSettingsReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SingleStepReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.TargetInformationReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.TerminateReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ValidateMemoryReply;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.DebugEventListenerAdapter;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.DebugTargetSettings;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerErrorCodes;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import com.google.security.zynamics.binnavi.debug.models.storage.DebuggerEventSettingsStorage;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public final class CDebugEventNotifier {
    private final JFrame m_parent;
    private final IDebugger m_debugger;
    private final DebugTargetSettings m_debugTarget;
    private final IViewContainer m_viewContainer;
    private final InternalDebuggerListener m_debuglistener = new InternalDebuggerListener();
    private final InternalThreadEventListener m_threadEventListener = new InternalThreadEventListener();
    private final ProcessManagerListener m_processListener = new InternalProcessListener();

    public CDebugEventNotifier(JFrame parent, IDebugger debugger, DebugTargetSettings debugTarget, IViewContainer viewContainer) {
        this.m_parent = parent;
        this.m_debugTarget = Preconditions.checkNotNull(debugTarget, "IE02292: debugTarget argument can not be null");
        this.m_viewContainer = Preconditions.checkNotNull(viewContainer, "IE02293: viewContainer argument can not be null");
        this.m_debugger = Preconditions.checkNotNull(debugger, "IE02294: debugger argument can not be null");
    }

    private JFrame activateWindow() {
        for (IGraphContainerWindow iGraphContainerWindow : CWindowManager.instance().getOpenWindows()) {
            for (IGraphPanel graphPanel : iGraphContainerWindow) {
                BackEndDebuggerProvider debuggerProvider = graphPanel.getModel().getDebuggerProvider();
                for (IDebugger d2 : debuggerProvider) {
                    if (d2 != this.m_debugger) continue;
                    iGraphContainerWindow.activate(graphPanel);
                    iGraphContainerWindow.show();
                    return iGraphContainerWindow.getFrame();
                }
            }
        }
        return null;
    }

    private void selectView(List<INaviView> views) {
        CGraphSelectionDialog dlg = new CGraphSelectionDialog(this.m_parent, views);
        dlg.setVisible(true);
        INaviView result = dlg.getSelectionResult();
        if (result != null) {
            CViewOpener.showView(this.m_parent, this.m_viewContainer, result, CWindowManager.instance().getLastWindow());
        }
    }

    public void start() {
        this.m_debugger.addListener(this.m_debuglistener);
        ProcessManager processManager = this.m_debugger.getProcessManager();
        processManager.addListener(this.m_processListener);
        for (TargetProcessThread thread2 : processManager.getThreads()) {
            thread2.addListener(this.m_threadEventListener);
        }
    }

    public void stop() {
        this.m_debugger.removeListener(this.m_debuglistener);
        ProcessManager processManager = this.m_debugger.getProcessManager();
        processManager.removeListener(this.m_processListener);
        for (TargetProcessThread thread2 : processManager.getThreads()) {
            thread2.removeListener(this.m_threadEventListener);
        }
    }

    private class InternalThreadEventListener
    extends ThreadListenerAdapter {
        private InternalThreadEventListener() {
        }

        @Override
        public void instructionPointerChanged(TargetProcessThread thread2, RelocatedAddress oldAddress) {
            if (thread2 != CDebugEventNotifier.this.m_debugger.getProcessManager().getActiveThread()) {
                return;
            }
            RelocatedAddress threadAddress = thread2.getCurrentAddress();
            if (threadAddress == null) {
                return;
            }
            if (oldAddress != null && oldAddress.equals(threadAddress)) {
                return;
            }
            if (CGlobalSettings.SHOW_DIALOGS) {
                UnrelocatedAddress address = CDebugEventNotifier.this.m_debugger.memoryToFile(threadAddress);
                INaviModule naviModule = CDebugEventNotifier.this.m_debugger.getModule(threadAddress);
                IGraphPanel panel = CPanelFinder.getPanelWithAddress(CDebugEventNotifier.this.m_debugger, address);
                if (panel == null) {
                    try {
                        List<INaviView> views = naviModule.getViewsWithAddresses(Lists.newArrayList(address), true);
                        if (views.size() > 0) {
                            CDebugEventNotifier.this.selectView(views);
                        }
                    }
                    catch (CouldntLoadDataException e2) {
                        CUtilityFunctions.logException(e2);
                    }
                } else {
                    CGraphWindow parent = panel.getModel().getParent();
                    parent.toFront();
                    parent.activate(panel);
                }
            }
        }
    }

    private class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void addedModule(MemoryModule module) {
            CRelocationNotifier.checkBaseAddresses(CDebugEventNotifier.this.m_parent, CDebugEventNotifier.this.m_debugger, CDebugEventNotifier.this.m_viewContainer, Lists.newArrayList(module));
        }

        @Override
        public void addedThread(TargetProcessThread thread2) {
            thread2.addListener(CDebugEventNotifier.this.m_threadEventListener);
        }

        @Override
        public void removedThread(TargetProcessThread thread2) {
            thread2.removeListener(CDebugEventNotifier.this.m_threadEventListener);
        }
    }

    private class InternalDebuggerListener
    extends DebugEventListenerAdapter {
        private InternalDebuggerListener() {
        }

        private void internalReceivedReply(AnyBreakpointRemovedReply reply) {
            Collection<Pair<RelocatedAddress, Integer>> failedAddresses = Collections2.filter(reply.getAddresses(), new Predicate<Pair<RelocatedAddress, Integer>>(){

                @Override
                public boolean apply(Pair<RelocatedAddress, Integer> item) {
                    return item.second() != 0;
                }
            });
            if (!Iterables.isEmpty(failedAddresses)) {
                CBreakpointRemovalDialog.show(CDebugEventNotifier.this.m_parent, failedAddresses);
            }
        }

        private void sendDebuggerEventSettings() {
            try {
                DebuggerEventSettingsStorage eventSettingsStorage = new DebuggerEventSettingsStorage(CDebugEventNotifier.this.m_debugger, CDebugEventNotifier.this.m_debugTarget);
                CDebugEventNotifier.this.m_debugger.setDebuggerEventSettings(eventSettingsStorage.deserialize());
            }
            catch (DebugExceptionWrapper exception) {
                CUtilityFunctions.logException(exception);
                String message2 = "Debugger event settings could not be sent to the debugger.";
                String description = CUtilityFunctions.createDescription(String.format("BinNavi could not send the debugger event settings to the debug client.", new Object[0]), new String[0], new String[]{"The default debugger event settings will be used during this session."});
                NaviErrorDialog.show(CDebugEventNotifier.this.m_parent, "Debugger event settings could not be sent to the debugger.", description, exception);
            }
            catch (CouldntLoadDataException exception) {
                CUtilityFunctions.logException(exception);
                String message3 = "Debugger event settings could not be retrieved from the database.";
                String description = CUtilityFunctions.createDescription(String.format("BinNavi could not send the debugger event settings to the debug client.", new Object[0]), new String[0], new String[]{"The default debugger event settings will be used during this session."});
                NaviErrorDialog.show(CDebugEventNotifier.this.m_parent, "Debugger event settings could not be retrieved from the database.", description, exception);
            }
        }

        private void sendExceptionSettings(TargetInformationReply reply) {
            try {
                CDebugEventNotifier.this.m_debugger.setExceptionSettings(CDebuggerFunctions.mergeExceptionsSettings(CDebugEventNotifier.this.m_debugTarget, reply.getTargetInformation().getDebuggerOptions().getExceptions(), CDebugEventNotifier.this.m_debugger.getId()));
            }
            catch (DebugExceptionWrapper exception) {
                CUtilityFunctions.logException(exception);
                String message2 = "Exception settings could not be sent to the debugger.";
                String description = CUtilityFunctions.createDescription(String.format("BinNavi could not send the exception settings to the debug client.", new Object[0]), new String[]{"BinNavi is unable to show the debugger options dialog until the problem is resolved."}, new String[]{"The default debugger options will be used during this session."});
                NaviErrorDialog.show(CDebugEventNotifier.this.m_parent, "Exception settings could not be sent to the debugger.", description, exception);
            }
            catch (CouldntLoadDataException exception) {
                CUtilityFunctions.logException(exception);
                String message3 = "Exception settings could not be loaded.";
                String description = CUtilityFunctions.createDescription(String.format("BinNavi could not load the exception settings from the database.", new Object[0]), new String[]{"Communication error while contacting the database"}, new String[]{"BinNavi is unable to read the exception settings from the database.", "The default exception settings will be used during this session."});
                NaviErrorDialog.show(CDebugEventNotifier.this.m_parent, "Exception settings could not be loaded.", description, exception);
            }
        }

        @Override
        public void debugException(DebugExceptionWrapper debugException) {
            String innerMessage = "E00074: An exception occurred during debugging";
            String innerDescription = "An exception occurred in the BinNavi debugger. You may want to check the stack trace to get more information.";
            NaviErrorDialog.show(CDebugEventNotifier.this.activateWindow(), "E00074: An exception occurred during debugging", "An exception occurred in the BinNavi debugger. You may want to check the stack trace to get more information.", debugException);
        }

        @Override
        public void debuggerClosed(int code2) {
            if (code2 != 0) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), "The connection to the debug client terminated unexpectedly.");
            }
            CDebugEventNotifier.this.stop();
        }

        @Override
        public void receivedReply(AttachReply reply) {
            if (!reply.success()) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), "The debug client could not attach to the target process.");
                CDebugEventNotifier.this.stop();
            }
        }

        @Override
        public void receivedReply(AuthenticationFailedReply reply) {
            CMessageBox.showError(CDebugEventNotifier.this.m_parent, "Debug client did not correctly authenticate itself and can not be used.");
        }

        @Override
        public void receivedReply(BreakpointConditionSetReply reply) {
            if (!reply.success()) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), "Could not set the breakpoint condition");
            }
        }

        @Override
        public void receivedReply(BreakpointSetReply reply) {
            if (!reply.success()) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), String.format("Could not set a breakpoint at address %s.\n\nReason: %s", reply.getAddresses(), DebuggerErrorCodes.codeToMessage(reply.getErrorCode())));
            }
        }

        @Override
        public void receivedReply(BreakpointsRemovedReply reply) {
            this.internalReceivedReply(reply);
        }

        @Override
        public void receivedReply(DetachReply reply) {
            if (!reply.success()) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), String.format("Could not detach from the target process.\n\nReason: %s", DebuggerErrorCodes.codeToMessage(reply.getErrorCode())));
            }
        }

        @Override
        public void receivedReply(EchoBreakpointSetReply reply) {
            List<Pair<RelocatedAddress, Integer>> receivedAddresses = reply.getAddresses();
            for (Pair<RelocatedAddress, Integer> addressErrorPair : receivedAddresses) {
                RelocatedAddress relocatedAddress = addressErrorPair.first();
                BreakpointAddress breakPointAddress = DebuggerHelpers.getBreakpointAddress(CDebugEventNotifier.this.m_debugger, relocatedAddress);
                if (CDebugEventNotifier.this.m_debugger.getBreakpointManager().hasBreakpoint(BreakpointType.ECHO, breakPointAddress)) continue;
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), String.format("Breakpoint manager does not know break point with address: %x", breakPointAddress.getAddress().getAddress().toLong()));
                break;
            }
        }

        @Override
        public void receivedReply(EchoBreakpointsRemovedReply reply) {
            this.internalReceivedReply(reply);
        }

        @Override
        public void receivedReply(HaltReply reply) {
            if (!reply.success()) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), String.format("Could not halt the target process.\n\nReason: %s", DebuggerErrorCodes.codeToMessage(reply.getErrorCode())));
            }
        }

        @Override
        public void receivedReply(MemoryMapReply reply) {
            if (!reply.success()) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), String.format("Could not determine the memory layout of the target process.\n\nReason: %s", DebuggerErrorCodes.codeToMessage(reply.getErrorCode())));
            }
        }

        @Override
        public void receivedReply(ProcessClosedReply reply) {
            if (reply.success()) {
                CDebugEventNotifier.this.stop();
                CMessageBox.showInformation(CDebugEventNotifier.this.activateWindow(), "The target process terminated.");
            }
        }

        @Override
        public void receivedReply(QueryDebuggerEventSettingsReply reply) {
            this.sendDebuggerEventSettings();
        }

        @Override
        public void receivedReply(ReadMemoryReply reply) {
            if (!reply.success()) {
                NaviLogger.info(String.format("Could not read memory from the target process since the memory map might have changed. Refreshing the memory map.\nError code was: %d", reply.getErrorCode()), new Object[0]);
            }
        }

        @Override
        public void receivedReply(RegistersReply reply) {
            if (!reply.success()) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), String.format("Could not read the registers of the target thread.\n\nReason: %s", DebuggerErrorCodes.codeToMessage(reply.getErrorCode())));
            }
        }

        @Override
        public void receivedReply(RequestTargetReply reply) {
            if (reply.success()) {
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        CRemoteFileBrowserLoader loader = new CRemoteFileBrowserLoader(CDebugEventNotifier.this.m_parent, CDebugEventNotifier.this.m_debugger);
                        if (!loader.load()) {
                            try {
                                CDebugEventNotifier.this.m_debugger.cancelTargetSelection();
                                CDebugEventNotifier.this.stop();
                            }
                            catch (DebugExceptionWrapper e2) {
                                CUtilityFunctions.logException(e2);
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void receivedReply(SetExceptionSettingsReply reply) {
            if (!reply.success()) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), "Debug client was unable to set the specified exception settings.");
            }
        }

        @Override
        public void receivedReply(SingleStepReply reply) {
            if (!reply.success()) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), String.format("Could not do single-step operation.\n\nReason: %s", DebuggerErrorCodes.codeToMessage(reply.getErrorCode())));
            }
        }

        @Override
        public void receivedReply(TargetInformationReply reply) {
            this.sendExceptionSettings(reply);
        }

        @Override
        public void receivedReply(TerminateReply reply) {
            if (!reply.success()) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), String.format("Could not terminate the target process.\n\nReason: %s", DebuggerErrorCodes.codeToMessage(reply.getErrorCode())));
            }
        }

        @Override
        public void receivedReply(ValidateMemoryReply reply) {
            if (!reply.success()) {
                CMessageBox.showError(CDebugEventNotifier.this.activateWindow(), String.format("Could not validate the memory of the target process.\n\nReason: %s", DebuggerErrorCodes.codeToMessage(reply.getErrorCode())));
            }
        }
    }
}

