/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.Notifier;

import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class CBreakpointModuleSynchronizer {
    private CBreakpointModuleSynchronizer() {
    }

    private static boolean isWithinModule(IDebugger debugger, MemoryModule module, Breakpoint breakpoint) {
        RelocatedAddress bpAddress = debugger.fileToMemory(breakpoint.getAddress().getModule(), breakpoint.getAddress().getAddress());
        boolean addressOk = bpAddress.getAddress().toBigInteger().compareTo(module.getBaseAddress().getAddress().toBigInteger()) >= 0 && bpAddress.getAddress().toBigInteger().compareTo(module.getBaseAddress().getAddress().toBigInteger().add(BigInteger.valueOf(module.getSize()))) <= 0;
        return addressOk && module.getName().compareToIgnoreCase(breakpoint.getAddress().getModule().getConfiguration().getName()) == 0;
    }

    private static void processModuleBreakpoints(IDebugger debugger, MemoryModule module, BreakpointType breakPointType, IModuleBreakpointEnumerator callback) {
        BreakpointManager manager = debugger.getBreakpointManager();
        HashSet<BreakpointAddress> breakpointAddresses = new HashSet<BreakpointAddress>();
        for (Breakpoint breakpoint : manager.getBreakpointsByModule(breakPointType, module)) {
            if (manager.getBreakpointStatus(breakpoint.getAddress(), breakpoint.getType()) == BreakpointStatus.BREAKPOINT_ENABLED || manager.getBreakpointStatus(breakpoint.getAddress(), breakpoint.getType()) == BreakpointStatus.BREAKPOINT_DISABLED || !CBreakpointModuleSynchronizer.isWithinModule(debugger, module, breakpoint)) continue;
            breakpointAddresses.add(breakpoint.getAddress());
        }
        callback.handleAddress(manager, breakpointAddresses);
    }

    public static void disableEchoBreakpoints(IDebugger debugger, MemoryModule module) {
        CBreakpointModuleSynchronizer.processModuleBreakpoints(debugger, module, BreakpointType.ECHO, new DisableBreakpointsAction(BreakpointType.ECHO));
    }

    public static void disableRegularBreakpoints(IDebugger debugger, MemoryModule module) {
        CBreakpointModuleSynchronizer.processModuleBreakpoints(debugger, module, BreakpointType.REGULAR, new DisableBreakpointsAction(BreakpointType.REGULAR));
    }

    public static void enableEchoBreakpoints(IDebugger debugger, MemoryModule module) {
        CBreakpointModuleSynchronizer.processModuleBreakpoints(debugger, module, BreakpointType.ECHO, new EnableBreakpointsAction(BreakpointType.ECHO));
    }

    public static void enableRegularBreakpoints(IDebugger debugger, MemoryModule module) {
        CBreakpointModuleSynchronizer.processModuleBreakpoints(debugger, module, BreakpointType.REGULAR, new EnableBreakpointsAction(BreakpointType.REGULAR));
    }

    private static interface IModuleBreakpointEnumerator {
        public void handleAddress(BreakpointManager var1, Set<BreakpointAddress> var2);
    }

    private static class EnableBreakpointsAction
    implements IModuleBreakpointEnumerator {
        private final BreakpointType m_bpType;

        public EnableBreakpointsAction(BreakpointType bpType) {
            this.m_bpType = bpType;
        }

        @Override
        public void handleAddress(BreakpointManager manager, Set<BreakpointAddress> breakpoints) {
            manager.setBreakpointStatus(breakpoints, this.m_bpType, BreakpointStatus.BREAKPOINT_ENABLED);
        }
    }

    private static class DisableBreakpointsAction
    implements IModuleBreakpointEnumerator {
        private final BreakpointType m_bpType;

        public DisableBreakpointsAction(BreakpointType bpType) {
            this.m_bpType = bpType;
        }

        @Override
        public void handleAddress(BreakpointManager manager, Set<BreakpointAddress> breakpoints) {
            manager.setBreakpointStatus(breakpoints, this.m_bpType, BreakpointStatus.BREAKPOINT_INACTIVE);
        }
    }
}

