/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.CMemoryFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessHelpers;
import java.awt.Window;

public final class CModulesPanelFunctions {
    private CModulesPanelFunctions() {
    }

    public static void gotoModule(Window parent, CDebugPerspectiveModel debugPerspectiveModel, MemoryModule module) {
        Preconditions.checkNotNull(parent, "IE01462: Parent argument can not be null");
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01463: Debug perspective model argument can not be null");
        Preconditions.checkNotNull(module, "IE01464: Module argument can not be null");
        IDebugger debugger = debugPerspectiveModel.getCurrentSelectedDebugger();
        if (debugger == null) {
            return;
        }
        MemoryMap memoryMap = debugger.getProcessManager().getMemoryMap();
        MemorySection section = ProcessHelpers.getSectionWith(memoryMap, module.getBaseAddress().getAddress());
        if (section == null) {
            String message2 = String.format("E00046: Could not display module '%s' in the memory view", module.getName());
            String description = String.format("The module '%s' could not be displayed in the memory view because the offset %s is not currently known to BinNavi. Try refreshing the memory map to fix this issue.", module.getName(), module.getBaseAddress());
            NaviErrorDialog.show(parent, message2, description);
        } else {
            CMemoryFunctions.gotoOffset(debugPerspectiveModel, module.getBaseAddress().getAddress(), true);
        }
    }
}

