/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel.CModulesTable;
import com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel.CModulesTableModel;
import com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel.CModulesTableRenderer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;

public final class CModulesTableModelSynchronizer {
    private final CModulesTableModel m_model;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final CModulesTableRenderer m_renderer;
    private final IDebugPerspectiveModelListener m_listener = new InternalDebuggerListener();
    private final ProcessManagerListener m_processListener = new InternalProcessListener();

    public CModulesTableModelSynchronizer(CModulesTable table, CDebugPerspectiveModel debugPerspectiveModel) {
        Preconditions.checkNotNull(table, "IE01460: Model argument can not be null");
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01461: Debug perspective model argument can not be null");
        this.m_model = table.getTreeTableModel();
        this.m_renderer = table.getDefaultRenderer();
        this.m_debugPerspectiveModel = debugPerspectiveModel;
        this.synchronizeDebugger(null, debugPerspectiveModel.getCurrentSelectedDebugger());
        debugPerspectiveModel.addListener(this.m_listener);
    }

    private void synchronizeDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
        if (oldDebugger != null) {
            oldDebugger.getProcessManager().removeListener(this.m_processListener);
        }
        this.m_model.reset();
        if (newDebugger != null) {
            for (MemoryModule module : newDebugger.getProcessManager().getModules()) {
                this.m_model.addModule(module);
            }
            newDebugger.getProcessManager().addListener(this.m_processListener);
        }
    }

    public void dispose() {
        this.m_debugPerspectiveModel.removeListener(this.m_listener);
        this.synchronizeDebugger(this.m_debugPerspectiveModel.getCurrentSelectedDebugger(), null);
    }

    private class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void addedModule(MemoryModule module) {
            CModulesTableModelSynchronizer.this.m_renderer.addModule(module);
            CModulesTableModelSynchronizer.this.m_model.addModule(module);
        }

        @Override
        public void detached() {
            CModulesTableModelSynchronizer.this.m_model.reset();
        }

        @Override
        public void removedModule(MemoryModule module) {
            CModulesTableModelSynchronizer.this.m_model.removeModule(module);
        }
    }

    private class InternalDebuggerListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalDebuggerListener() {
        }

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            CModulesTableModelSynchronizer.this.synchronizeDebugger(oldDebugger, newDebugger);
        }
    }
}

