/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemorySectionPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.MemorySectionPanel.CMemorySectionBox;
import com.google.security.zynamics.binnavi.Gui.Debug.MemorySectionPanel.CMemorySectionWrapper;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessHelpers;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ThreadListener;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

public final class CMemorySectionPanelSynchronizer {
    private final CMemorySectionBox memorySectionBox;
    private final CDebugPerspectiveModel debugPerspectiveModel;
    private final ProcessManagerListener processManagerListener = new InternalProcessManagerListener();
    private final IDebugPerspectiveModelListener debugListener = new InternalDebugListener();
    private final ItemListener memoryBoxListener = new InternalMemMapChangeListener();
    private boolean updating;
    private final ThreadListener threadListener = new InternalThreadListener();

    public CMemorySectionPanelSynchronizer(CMemorySectionBox sectionBox, CDebugPerspectiveModel debugPerspectiveModel) {
        this.memorySectionBox = Preconditions.checkNotNull(sectionBox, "IE01454: Section box argument can not be null");
        this.debugPerspectiveModel = Preconditions.checkNotNull(debugPerspectiveModel, "IE01455: Debug perspective model argument can not be null");
        this.synchronizeDebugger(null, debugPerspectiveModel.getCurrentSelectedDebugger());
        debugPerspectiveModel.addListener(this.debugListener);
        this.memorySectionBox.addItemListener(this.memoryBoxListener);
    }

    private void synchronizeDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
        TargetProcessThread oldThread = null;
        if (oldDebugger != null) {
            oldDebugger.getProcessManager().removeListener(this.processManagerListener);
            oldThread = oldDebugger.getProcessManager().getActiveThread();
        }
        if (newDebugger != null) {
            newDebugger.getProcessManager().addListener(this.processManagerListener);
            TargetInformation targetInformation = newDebugger.getProcessManager().getTargetInformation();
            if (targetInformation != null) {
                this.updateMemoryBox();
            }
            this.synchronizeThreads(oldThread, newDebugger.getProcessManager().getActiveThread());
        }
        this.updateGui();
    }

    private void synchronizeThreads(TargetProcessThread oldThread, TargetProcessThread newThread) {
        if (oldThread != null) {
            oldThread.removeListener(this.threadListener);
        }
        if (newThread != null) {
            newThread.addListener(this.threadListener);
        }
        this.updateGui();
    }

    private void updateGui() {
        IDebugger activeDebugger = this.debugPerspectiveModel.getCurrentSelectedDebugger();
        TargetProcessThread activeThread = activeDebugger == null ? null : activeDebugger.getProcessManager().getActiveThread();
        final boolean enable = activeThread != null && activeDebugger != null && activeDebugger.isConnected() && activeDebugger.getProcessManager().getTargetInformation() != null && activeDebugger.getProcessManager().getTargetInformation().getDebuggerOptions().canMemmap() && this.memorySectionBox.getItemCount() != 0;
        new SwingInvoker(){

            @Override
            protected void operation() {
                CMemorySectionPanelSynchronizer.this.memorySectionBox.setEnabled(enable);
            }
        }.invokeAndWait();
    }

    private void updateMemoryBox() {
        final IDebugger activeDebugger = this.debugPerspectiveModel.getCurrentSelectedDebugger();
        final ArrayList<CMemorySectionWrapper> sections = new ArrayList<CMemorySectionWrapper>();
        if (activeDebugger != null && activeDebugger.isConnected()) {
            for (MemorySection section : activeDebugger.getProcessManager().getMemoryMap()) {
                sections.add(new CMemorySectionWrapper(section));
            }
        }
        new SwingInvoker(){

            @Override
            protected void operation() {
                CMemorySectionPanelSynchronizer.this.memorySectionBox.removeAllItems();
                if (activeDebugger != null && activeDebugger.isConnected()) {
                    for (CMemorySectionWrapper sectionWrapper : sections) {
                        CMemorySectionPanelSynchronizer.this.memorySectionBox.addItem(sectionWrapper);
                    }
                }
            }
        }.invokeAndWait();
    }

    public void dispose() {
        this.memorySectionBox.removeItemListener(this.memoryBoxListener);
        this.debugPerspectiveModel.removeListener(this.debugListener);
        IDebugger activeDebugger = this.debugPerspectiveModel.getCurrentSelectedDebugger();
        if (activeDebugger != null) {
            this.synchronizeThreads(activeDebugger.getProcessManager().getActiveThread(), null);
        }
        this.synchronizeDebugger(this.debugPerspectiveModel.getCurrentSelectedDebugger(), null);
    }

    private class InternalThreadListener
    extends ThreadListenerAdapter {
        private InternalThreadListener() {
        }

        @Override
        public void stateChanged(TargetProcessThread thread2) {
            CMemorySectionPanelSynchronizer.this.updateGui();
        }
    }

    private class InternalProcessManagerListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessManagerListener() {
        }

        @Override
        public void changedActiveThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
            CMemorySectionPanelSynchronizer.this.synchronizeThreads(oldThread, newThread);
            CMemorySectionPanelSynchronizer.this.updateGui();
        }

        @Override
        public void changedMemoryMap() {
            CMemorySectionPanelSynchronizer.this.updating = true;
            IAddress previousAddress = CMemorySectionPanelSynchronizer.this.debugPerspectiveModel.getActiveAddress();
            CMemorySectionPanelSynchronizer.this.updateMemoryBox();
            CMemorySectionPanelSynchronizer.this.updateGui();
            IDebugger activeDebugger = CMemorySectionPanelSynchronizer.this.debugPerspectiveModel.getCurrentSelectedDebugger();
            if (activeDebugger != null) {
                MemoryMap memoryMap = activeDebugger.getProcessManager().getMemoryMap();
                if (previousAddress == null) {
                    CMemorySectionPanelSynchronizer.this.updating = false;
                    if (memoryMap.getNumberOfSections() != 0) {
                        MemorySection firstSection = memoryMap.getSection(0);
                        CMemorySectionPanelSynchronizer.this.debugPerspectiveModel.setActiveMemoryAddress(firstSection.getStart(), false);
                    }
                } else {
                    MemorySection updatedSection = ProcessHelpers.getSectionWith(memoryMap, previousAddress);
                    CMemorySectionPanelSynchronizer.this.memorySectionBox.setSelectedItem(updatedSection);
                    CMemorySectionPanelSynchronizer.this.updating = false;
                }
            }
        }

        @Override
        public void changedTargetInformation(TargetInformation information) {
            CMemorySectionPanelSynchronizer.this.updateMemoryBox();
            CMemorySectionPanelSynchronizer.this.updateGui();
        }
    }

    private class InternalMemMapChangeListener
    implements ItemListener {
        private InternalMemMapChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (CMemorySectionPanelSynchronizer.this.updating) {
                return;
            }
            CMemorySectionWrapper section = CMemorySectionPanelSynchronizer.this.memorySectionBox.getSelectedItem();
            if (section == null) {
                return;
            }
            CMemorySectionPanelSynchronizer.this.debugPerspectiveModel.setActiveMemoryAddress(((MemorySection)section.getObject()).getStart(), false);
        }
    }

    private class InternalDebugListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalDebugListener() {
        }

        @Override
        public void changedActiveAddress(IAddress address, boolean focusMemoryWindow) {
            if (address == null) {
                return;
            }
            if (CMemorySectionPanelSynchronizer.this.updating) {
                return;
            }
            CMemorySectionPanelSynchronizer.this.updating = true;
            IDebugger activeDebugger = CMemorySectionPanelSynchronizer.this.debugPerspectiveModel.getCurrentSelectedDebugger();
            if (activeDebugger != null) {
                MemorySection section = ProcessHelpers.getSectionWith(activeDebugger.getProcessManager().getMemoryMap(), address);
                CMemorySectionPanelSynchronizer.this.memorySectionBox.setSelectedItem(section);
            }
            CMemorySectionPanelSynchronizer.this.updating = false;
        }

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            CMemorySectionPanelSynchronizer.this.synchronizeDebugger(oldDebugger, newDebugger);
        }
    }
}

