/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryRefreshButton.Actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryRefreshButton.IRefreshRangeProvider;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryRefreshButton.Implementations.CMemorySelectionFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IFrontEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public final class CRefreshAction
extends AbstractAction {
    private static final long serialVersionUID = 3258591696396189580L;
    private final JFrame m_parent;
    private final IFrontEndDebuggerProvider m_debugPerspectiveModel;
    private final IRefreshRangeProvider m_rangeProvider;
    private final IRefreshRangeProvider m_stackRangeProvider;

    public CRefreshAction(JFrame parent, IFrontEndDebuggerProvider debugPerspectiveModel, IRefreshRangeProvider rangeProvider, IRefreshRangeProvider stackRangeProvider) {
        Preconditions.checkNotNull(parent, "IE01448: Parent argument can not be null");
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01449: Debug perspective model argument can not be null");
        this.m_parent = parent;
        this.m_debugPerspectiveModel = debugPerspectiveModel;
        this.m_rangeProvider = rangeProvider;
        this.m_stackRangeProvider = stackRangeProvider;
        this.putValue("SmallIcon", new ImageIcon(CMain.class.getResource("data/memoryupdate_up.jpg")));
        this.putValue("ShortDescription", "Refresh Memory");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        IDebugger debugger = this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
        if (debugger != null) {
            CMemorySelectionFunctions.refreshMemory(this.m_parent, debugger, this.m_rangeProvider.getAddress(), this.m_rangeProvider.getSize());
            IAddress stackAddress = this.m_stackRangeProvider.getAddress();
            int size = this.m_stackRangeProvider.getSize();
            if (stackAddress != null && size != 0) {
                CMemorySelectionFunctions.refreshMemory(this.m_parent, debugger, stackAddress, size);
            }
        }
    }
}

