/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.Gui.Debug.Goto.CGotoDialog;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.CMemoryViewer;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.CDefaultMemoryExpressionBinding;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.CDumpAllWaiter;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.CSearchWaiter;
import com.google.security.zynamics.binnavi.Gui.Debug.SearchMemory.CSearchDialog;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.LastDirFileChooser;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SearchReply;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.memmanager.Memory;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.JHexPanel.IDataProvider;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.awt.Color;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;

public final class CMemoryFunctions {
    private CMemoryFunctions() {
    }

    private static void checkArguments(Window parent, IDebugger debugger) {
        Preconditions.checkNotNull(parent, "IE01434: Parent argument can not be null");
        Preconditions.checkNotNull(debugger, "IE01433: Debugger argument can not be null");
    }

    private static void checkArguments(Window parent, IDebugger debugger, IAddress offset) {
        CMemoryFunctions.checkArguments(parent, debugger);
        Preconditions.checkNotNull(offset, "IE01432: Offset argument can not be null");
    }

    private static Pair<Integer, File> showSaveDialog(JFrame parent) {
        LastDirFileChooser fileChooser = new LastDirFileChooser();
        fileChooser.setDialogTitle("Save Data to File");
        int val = fileChooser.showSaveDialog(parent);
        return new Pair<Integer, File>(val, fileChooser.getSelectedFile());
    }

    public static void dumpMemoryRange(JFrame parent, IDebugger debugger, IDataProvider dataProvider, IAddress offset, int size) {
        CMemoryFunctions.checkArguments(parent, debugger, offset);
        Pair<Integer, File> result = CMemoryFunctions.showSaveDialog(parent);
        if (result.first() == 0) {
            CMemoryFunctions.loadAll(parent, debugger, offset, size);
            if (dataProvider.hasData(offset.toLong(), size)) {
                try {
                    byte[] data = dataProvider.getData(offset.toLong(), size);
                    FileUtils.writeBinaryFile(result.second(), data);
                    CMessageBox.showInformation(parent, String.format("Memory data was successfully written to %s", result.second()));
                }
                catch (IOException e2) {
                    String innerMessage = "E00151: Could not write memory data to the target file";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The memory data of the selected range could not be written to the file '%s'.", result.second().getAbsolutePath()), new String[]{"You do not have sufficient rights to write to the file.", "Another program locks the selected file.", "The disk is full."}, new String[]{"The memory data was not written to the file."});
                    NaviErrorDialog.show(parent, "E00151: Could not write memory data to the target file", innerDescription, e2);
                }
            } else {
                String innerMessage = "E00152: Could not read memory";
                String innerDescription = CUtilityFunctions.createDescription("The memory section to be dumped could not be read.", new String[]{"There was a problem with the database connection."}, new String[]{"The memory data could not be read and the output file was not written."});
                NaviErrorDialog.show(parent, "E00152: Could not read memory", innerDescription);
            }
        }
    }

    public static void gotoOffset(CDebugPerspectiveModel model, IAddress offset, boolean focusMemoryWindow) {
        model.setActiveMemoryAddress(offset, focusMemoryWindow);
    }

    public static void gotoOffset(JFrame parent, CMemoryViewer view, CDebugPerspectiveModel model) {
        IDebugger debugger = model.getCurrentSelectedDebugger();
        if (debugger == null) {
            return;
        }
        TargetProcessThread activeThread = debugger.getProcessManager().getActiveThread();
        Memory memory = debugger.getProcessManager().getMemory();
        CDefaultMemoryExpressionBinding binding = new CDefaultMemoryExpressionBinding(activeThread, memory);
        CGotoDialog dlg = new CGotoDialog(parent, model.getCurrentSelectedDebugger().getProcessManager().getMemoryMap(), binding, model.getGotoAddress());
        dlg.setVisible(true);
        IAddress value = dlg.getValue();
        if (value != null) {
            model.setGotoAddress(value);
            model.setActiveMemoryAddress(value, true);
            view.requestFocusInWindow();
        }
    }

    public static void loadAll(JFrame parent, IDebugger debugger, IAddress offset, int size) {
        CMemoryFunctions.checkArguments(parent, debugger, offset);
        CDumpAllWaiter waiter = new CDumpAllWaiter(debugger, offset, size);
        CProgressDialog.showEndless(parent, "Loading memory ...", waiter);
        if (waiter.getException() != null) {
            CUtilityFunctions.logException(waiter.getException());
            String innerMessage = "E00078: Could not load memory section";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The memory section starting at address '%s' could not loaded.", offset.toHexString()), new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The memory data was not loaded."});
            NaviErrorDialog.show(parent, "E00078: Could not load memory section", innerDescription, waiter.getException());
        }
    }

    public static void searchMemory(Window parent, IDebugger debugger, CMemoryViewer memoryView) {
        CMemoryFunctions.checkArguments(parent, debugger);
        Preconditions.checkNotNull(memoryView, "IE01431: Memory view argument can not be null");
        CSearchDialog dlg = new CSearchDialog(parent);
        byte[] data = dlg.getSearchData();
        if (data != null && data.length != 0) {
            JHexView hexView = memoryView.getHexView();
            long start = hexView.getCurrentOffset();
            int size = (int)(hexView.getLastOffset() - hexView.getCurrentOffset());
            CSearchWaiter waiter = new CSearchWaiter(debugger, new CAddress(start), size, data);
            CProgressDialog.showEndless(parent, "Loading memory ...", waiter);
            hexView.uncolorizeAll();
            if (waiter.getException() == null) {
                SearchReply reply = waiter.getReply();
                if (reply != null) {
                    IAddress offset = reply.getAddress();
                    if (reply.success()) {
                        if (hexView.isEnabled() && hexView.getDefinitionStatus() == JHexView.DefinitionStatus.DEFINED) {
                            hexView.colorize(5, offset.toLong(), data.length, Color.BLACK, Color.YELLOW);
                            hexView.gotoOffset(offset.toLong());
                            hexView.requestFocusInWindow();
                        }
                    } else {
                        CMessageBox.showInformation(parent, "The specified search string was not found.");
                    }
                }
            } else {
                CUtilityFunctions.logException(waiter.getException());
                String innerMessage = "E00079: Could not search through memory";
                String innerDescription = CUtilityFunctions.createDescription("It was not possible to send the search request to the debug client.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The search operation could not be started."});
                NaviErrorDialog.show(parent, "E00079: Could not search through memory", innerDescription, waiter.getException());
            }
        }
    }
}

