/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations;

import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.CEvaluationException;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.IMemoryExpressionBinding;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.MemoryExpression;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.MemoryExpressionElement;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.MemoryExpressionVisitor;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.MinusExpression;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.MultiplicationExpression;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.NumericalValue;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.PlusExpression;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.Register;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.SubExpression;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CEvaluationVisitor
implements MemoryExpressionVisitor {
    private final IMemoryExpressionBinding m_binding;
    private final Map<MemoryExpressionElement, BigInteger> m_partialEvaluationMap = new HashMap<MemoryExpressionElement, BigInteger>();
    private final List<String> m_errorMessages = new ArrayList<String>();

    public CEvaluationVisitor(IMemoryExpressionBinding binding) {
        this.m_binding = binding;
    }

    public List<String> getErrorMessages() {
        return new FilledList<String>((Collection<String>)this.m_errorMessages);
    }

    public BigInteger getValue(MemoryExpressionElement expression) {
        return this.m_partialEvaluationMap.get(expression);
    }

    @Override
    public void visit(MemoryExpression memoryExpression) {
        MemoryExpressionElement child = memoryExpression.getChild();
        child.visit(this);
        BigInteger address = this.getValue(child);
        try {
            this.m_partialEvaluationMap.put(memoryExpression, this.m_binding.getValue(address));
        }
        catch (CEvaluationException e2) {
            this.m_errorMessages.add(String.format("Unknown memory address %s", address.toString(16)));
        }
    }

    @Override
    public void visit(MinusExpression expression) {
        BigInteger value = null;
        for (MemoryExpressionElement child : expression.getChildren()) {
            child.visit(this);
            BigInteger childValue = this.getValue(child);
            if (childValue == null) {
                return;
            }
            if (value == null) {
                value = this.getValue(child);
                if (value != null) continue;
                return;
            }
            value = value.subtract(this.getValue(child));
        }
        this.m_partialEvaluationMap.put(expression, value);
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        BigInteger value = null;
        for (MemoryExpressionElement child : expression.getChildren()) {
            child.visit(this);
            BigInteger childValue = this.getValue(child);
            if (childValue == null) {
                return;
            }
            if (value == null) {
                value = this.getValue(child);
                if (value != null) continue;
                return;
            }
            value = value.multiply(this.getValue(child));
        }
        this.m_partialEvaluationMap.put(expression, value);
    }

    @Override
    public void visit(NumericalValue expression) {
        this.m_partialEvaluationMap.put(expression, expression.getValue());
    }

    @Override
    public void visit(PlusExpression expression) {
        BigInteger value = null;
        for (MemoryExpressionElement child : expression.getChildren()) {
            child.visit(this);
            BigInteger childValue = this.getValue(child);
            if (childValue == null) {
                return;
            }
            if (value == null) {
                value = this.getValue(child);
                if (value != null) continue;
                return;
            }
            value = value.add(this.getValue(child));
        }
        this.m_partialEvaluationMap.put(expression, value);
    }

    @Override
    public void visit(Register expression) {
        try {
            this.m_partialEvaluationMap.put(expression, this.m_binding.getValue(expression.getName()));
        }
        catch (CEvaluationException e2) {
            this.m_errorMessages.add(String.format("Unknown register %s", expression.getName()));
        }
    }

    @Override
    public void visit(SubExpression expression) {
        MemoryExpressionElement child = expression.getChild();
        child.visit(this);
        BigInteger childValue = this.getValue(child);
        if (childValue == null) {
            return;
        }
        this.m_partialEvaluationMap.put(expression, childValue);
    }
}

