/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IMemoryProvider;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.memmanager.IMemoryListener;
import com.google.security.zynamics.zylib.gui.JHexPanel.IDataChangedListener;
import com.google.security.zynamics.zylib.gui.JHexPanel.IDataProvider;
import java.math.BigInteger;

public final class CMemoryProvider
implements IDataProvider,
IMemoryListener {
    private IMemoryProvider m_memoryProvider;
    private int m_size;
    private final ListenerProvider<IDataChangedListener> m_listeners = new ListenerProvider();
    private IDebugger m_debugger;

    private void notifyChanged() {
        for (IDataChangedListener listener : this.m_listeners) {
            try {
                listener.dataChanged();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void addListener(IDataChangedListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public byte[] getData() {
        return this.getData(0L, this.getDataLength());
    }

    @Override
    public byte[] getData(long offset, int length) {
        Preconditions.checkArgument(length >= 0, "IE01401: Length can not be negative");
        if (length == 0) {
            return new byte[0];
        }
        return this.m_debugger.getProcessManager().getMemory().getData(offset, length);
    }

    @Override
    public int getDataLength() {
        return this.m_size;
    }

    @Override
    public boolean hasData(long offset, int size) {
        Preconditions.checkArgument(size >= 0, "IE01402: Size can not be negative");
        this.m_memoryProvider.hasData(BigInteger.valueOf(offset), size);
        return this.m_debugger.getProcessManager().getMemory().hasData(offset, size);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean keepTrying() {
        return this.m_debugger != null && this.m_debugger.isConnected();
    }

    @Override
    public void memoryChanged(long address, int size) {
        this.notifyChanged();
    }

    @Override
    public void memoryCleared() {
        this.notifyChanged();
    }

    @Override
    public void removeListener(IDataChangedListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void setData(long offset, byte[] data) {
        if (this.m_debugger != null) {
            try {
                this.m_debugger.writeMemory(new CAddress(offset), data);
                this.m_debugger.getProcessManager().getMemory().store(offset, data);
            }
            catch (DebugExceptionWrapper exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setDebugger(IDebugger debugger) {
        this.m_debugger = debugger;
        this.m_memoryProvider = debugger == null ? null : debugger.getMemoryProvider();
        this.notifyChanged();
    }

    public void setMemorySize(int size) {
        Preconditions.checkArgument(size >= 0, "IE01403: Size argument can not be negative");
        this.m_size = size;
        this.notifyChanged();
    }
}

