/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Actions.CCreateBookmarkAction;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Actions.CDeleteBookmarkAction;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Actions.CDumpMemoryRangeAction;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Actions.CFollowDumpAction;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Actions.CGotoAction;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Actions.CGotoBookmarkAction;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Actions.CLoadAllAction;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Actions.CSearchAction;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.CMemoryViewer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.HexViewOptionsMenu;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessHelpers;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.BookmarkManager;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.CBookmark;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ByteHelpers;
import com.google.security.zynamics.zylib.gui.JHexPanel.IMenuCreator;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class CMemoryMenu
implements IMenuCreator {
    private final JFrame m_parent;
    private final CDebugPerspectiveModel m_debugger;
    private final CMemoryViewer m_memoryView;

    public CMemoryMenu(JFrame parent, CDebugPerspectiveModel debugger, CMemoryViewer memoryView) {
        this.m_parent = Preconditions.checkNotNull(parent, "IE01396: Parent argument can not be null");
        this.m_debugger = Preconditions.checkNotNull(debugger, "IE01397: Debugger argument can not be null");
        this.m_memoryView = Preconditions.checkNotNull(memoryView, "IE01398: Memory view argument can not be null");
    }

    private boolean canReadDword(MemoryMap memoryMap, long offset) {
        return this.containsOffset(memoryMap, new CAddress(offset)) && this.containsOffset(memoryMap, new CAddress(offset + 3L));
    }

    private boolean containsOffset(MemoryMap memoryMap, IAddress offset) {
        return ProcessHelpers.getSectionWith(memoryMap, offset) != null;
    }

    @Override
    public JPopupMenu createMenu(long offset) {
        JPopupMenu menu = new JPopupMenu();
        IDebugger debugger = this.m_debugger.getCurrentSelectedDebugger();
        if (debugger == null) {
            return null;
        }
        menu.add(CActionProxy.proxy(new CSearchAction(this.m_parent, this.m_debugger, this.m_memoryView)));
        menu.add(CActionProxy.proxy(new CGotoAction(this.m_parent, this.m_memoryView, this.m_debugger)));
        if (this.canReadDword(debugger.getProcessManager().getMemoryMap(), offset)) {
            byte[] data = debugger.getProcessManager().getMemory().getData(offset, 4);
            CAddress dword = new CAddress(ByteHelpers.readDwordLittleEndian(data, 0));
            if (this.canReadDword(debugger.getProcessManager().getMemoryMap(), dword.toLong())) {
                menu.add(CActionProxy.proxy(new CFollowDumpAction(this.m_debugger, dword)));
            }
        }
        menu.addSeparator();
        long firstOffset = this.m_memoryView.getHexView().getBaseAddress();
        int size = this.m_memoryView.getHexView().getData().getDataLength();
        menu.add(new CLoadAllAction(this.m_parent, debugger, new CAddress(firstOffset), size));
        JMenu dumpMenu = new JMenu("Dump to file");
        dumpMenu.add(CActionProxy.proxy(new CDumpMemoryRangeAction(this.m_parent, debugger, this.m_memoryView.getHexView().getData(), new CAddress(firstOffset), size)));
        menu.add(dumpMenu);
        menu.addSeparator();
        BookmarkManager manager = debugger.getBookmarkManager();
        CBookmark bookmark = manager.getBookmark(new CAddress(offset));
        if (bookmark == null) {
            menu.add(new JMenuItem(CActionProxy.proxy(new CCreateBookmarkAction(manager, new CAddress(offset)))));
        } else {
            menu.add(new JMenuItem(CActionProxy.proxy(new CDeleteBookmarkAction(manager, bookmark))));
        }
        if (manager.getNumberOfBookmarks() != 0) {
            menu.addSeparator();
            JMenu bookmarksItem = new JMenu("Bookmarks");
            for (int i2 = 0; i2 < manager.getNumberOfBookmarks(); ++i2) {
                bookmarksItem.add(CActionProxy.proxy(new CGotoBookmarkAction(this.m_debugger, manager.getBookmark(i2))));
            }
            menu.add(bookmarksItem);
        }
        menu.addSeparator();
        menu.add(HexViewOptionsMenu.createHexViewOptionsMenu(this.m_memoryView.getHexView()));
        return menu;
    }
}

