/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.GraphSelectionDialog;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public final class CGraphSelectionTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7443878071502021510L;
    private static final String[] columns = new String[]{"Type", "Name", "Module"};
    private List<INaviView> m_views = null;

    public CGraphSelectionTableModel(List<INaviView> views) {
        Preconditions.checkNotNull(views, "IE01393: Views argument can not be null");
        this.m_views = new ArrayList<INaviView>(views);
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public String getColumnName(int col) {
        return columns[col];
    }

    @Override
    public int getRowCount() {
        return this.m_views == null ? 0 : this.m_views.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= 0 && row < this.m_views.size()) {
            switch (col) {
                case 0: {
                    return this.m_views.get(row).getType() == ViewType.Native ? "Function" : "Flowgraph";
                }
                case 1: {
                    return this.m_views.get(row).getName();
                }
                case 2: {
                    if (this.m_views.get(row).getConfiguration().getModule() != null) {
                        return this.m_views.get(row).getConfiguration().getModule().getConfiguration().getName();
                    }
                    return "Error: no module.";
                }
            }
            throw new IllegalArgumentException("IE01305: Unknown column");
        }
        throw new IllegalStateException("IE01307: Unknown row");
    }

    public List<INaviView> getViews() {
        return new ArrayList<INaviView>(this.m_views);
    }

    public void setViews(List<INaviView> views) {
        Preconditions.checkNotNull(views, "IE01450: List of flow graphs can't be null");
        this.m_views = new ArrayList<INaviView>(views);
        this.fireTableDataChanged();
    }
}

