/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.Goto;

import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.CEvaluationVisitor;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.IMemoryExpressionBinding;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.DebuggerMemoryExpressionParser;
import com.google.security.zynamics.binnavi.debug.models.memoryexpressions.MemoryExpressionElement;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessHelpers;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import com.google.security.zynamics.zylib.strings.Commafier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.antlr.runtime.RecognitionException;

public final class CGotoDialog
extends JDialog {
    private static final long serialVersionUID = 9134316385147292718L;
    private final JFrame m_parent;
    private final JTextField offsetField = new JTextField();
    private final IMemoryExpressionBinding m_bindings;
    private IAddress m_value = null;
    private final MemoryMap m_memoryMap;

    public CGotoDialog(JFrame parent, MemoryMap memoryMap, IMemoryExpressionBinding bindings, IAddress address) {
        super((Window)parent, "Goto Address", Dialog.ModalityType.APPLICATION_MODAL);
        this.m_memoryMap = memoryMap;
        this.m_bindings = bindings;
        if (address != null) {
            String string2 = String.valueOf(address.toHexString());
            this.offsetField.setText(string2.length() != 0 ? "0x".concat(string2) : new String("0x"));
        }
        this.setResizable(false);
        new CDialogEscaper(this);
        this.m_parent = parent;
        this.setLayout(new BorderLayout());
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BorderLayout());
        inputPanel.setBorder(new TitledBorder(""));
        JPanel fooPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Address: ");
        fooPanel.add((Component)label, "West");
        fooPanel.add((Component)this.offsetField, "Center");
        inputPanel.add((Component)fooPanel, "North");
        CPanelTwoButtons panel = new CPanelTwoButtons(new InternalListener(), "OK", "Cancel");
        this.getContentPane().add((Component)inputPanel, "North");
        this.getContentPane().add((Component)panel, "South");
        this.getRootPane().setDefaultButton(panel.getFirstButton());
        this.pack();
        this.setSize(300, 100);
        this.setLocationRelativeTo(null);
    }

    private void dialogClosedCancel() {
        this.dispose();
    }

    private void dialogClosedOk() {
        String input = this.offsetField.getText();
        if (!"".equals(input)) {
            try {
                MemoryExpressionElement expression = DebuggerMemoryExpressionParser.parse(input);
                CEvaluationVisitor visitor2 = new CEvaluationVisitor(this.m_bindings);
                expression.visit(visitor2);
                BigInteger value = visitor2.getValue(expression);
                if (value == null) {
                    String errors2 = Commafier.commafy(visitor2.getErrorMessages(), "\n");
                    CMessageBox.showError(this.m_parent, String.format("The expression you entered could not be evaluated:\n %s", errors2));
                } else if (value.compareTo(BigInteger.ZERO) == -1 || value.toString(16).length() > 8) {
                    CMessageBox.showError(this.m_parent, String.format("The expression you entered evaluates to the invalid memory address %s.", value.toString(16).toUpperCase()));
                } else {
                    MemorySection section = ProcessHelpers.getSectionWith(this.m_memoryMap, new CAddress(value.longValue()));
                    if (section == null) {
                        CMessageBox.showError(this.m_parent, String.format("There is no memory at address %s.", value.toString(16).toUpperCase()));
                    } else {
                        this.m_value = new CAddress(value.longValue());
                        this.dispose();
                    }
                }
            }
            catch (RecognitionException exception) {
                CMessageBox.showError(this.m_parent, "Invalid expression string.");
            }
        }
    }

    public IAddress getValue() {
        return this.m_value;
    }

    private class InternalListener
    implements ActionListener {
        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("OK")) {
                CGotoDialog.this.dialogClosedOk();
            } else {
                CGotoDialog.this.dialogClosedCancel();
            }
        }
    }
}

