/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Implementations;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.util.List;

public final class CTraceNodeFinder {
    private CTraceNodeFinder() {
    }

    private static boolean isEventNode(INaviCodeNode node, TraceList eventList) {
        for (ITraceEvent traceEvent : eventList) {
            BreakpointAddress eventAddress = traceEvent.getOffset();
            try {
                if (node.getParentFunction().getModule() != eventAddress.getModule() || !CCodeNodeHelpers.containsAddress(node, eventAddress.getAddress().getAddress())) continue;
                return true;
            }
            catch (MaybeNullException maybeNullException) {
            }
        }
        return false;
    }

    private static boolean isEventNode(INaviFunctionNode node, TraceList eventList) {
        for (ITraceEvent traceEvent : eventList) {
            if (traceEvent.getOffset().getModule() != node.getFunction().getModule() || !node.getFunction().getAddress().equals(traceEvent.getOffset().getAddress().getAddress())) continue;
            return true;
        }
        return false;
    }

    public static List<NaviNode> getTraceNodes(ZyGraph graph, final TraceList eventList) {
        return GraphHelpers.filter(graph, new ICollectionFilter<NaviNode>(){

            @Override
            public boolean qualifies(NaviNode item) {
                return item.getRawNode() instanceof INaviCodeNode && CTraceNodeFinder.isEventNode((INaviCodeNode)item.getRawNode(), eventList) || item.getRawNode() instanceof INaviFunctionNode && CTraceNodeFinder.isEventNode((INaviFunctionNode)item.getRawNode(), eventList);
            }
        });
    }
}

