/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists;

import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CMemoryFilterExpression;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CRegisterFilterExpression;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CTraceEventWrapper;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CTraceFilterExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.DefaultFilter;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.ConcreteTree.IFilterExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.FilterRelation;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.IPredicateGenerator;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.Wrappers.IFilterWrapper;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.Wrappers.IWrapperCreator;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.CDefaultFilterCreator;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CTraceFilterCreator
extends CDefaultFilterCreator<ITraceEvent, CTraceEventWrapper> {
    public CTraceFilterCreator() {
        super(Lists.newArrayList(new MemoryPredicateGenerator(), new RegisterPredicateGenerator(), new PlainTextPredicateGenerator()));
    }

    @Override
    protected IFilter<ITraceEvent> createFilter(IFilterExpression<CTraceEventWrapper> expression) {
        return new DefaultFilter<ITraceEvent, CTraceEventWrapper>(expression, new IWrapperCreator<ITraceEvent>(){

            @Override
            public IFilterWrapper<ITraceEvent> wrap(ITraceEvent element) {
                return new CTraceEventWrapper(element);
            }
        });
    }

    private static class RegisterPredicateGenerator
    implements IPredicateGenerator<CTraceEventWrapper> {
        private static final String RULE_REGEX = "\\s*([a-zA-Z0-9]+)\\s*(==|!=|<|>|<=|>=|<>)\\s*(0x)?([0-9a-fA-F]+)\\s*";

        private RegisterPredicateGenerator() {
        }

        @Override
        public boolean canParse(String text2) {
            Pattern pattern = Pattern.compile(RULE_REGEX);
            Matcher matcher = pattern.matcher(text2);
            if (!matcher.matches()) {
                return false;
            }
            boolean hasHexPrefix = matcher.group(3) != null;
            String value = matcher.group(4);
            try {
                Long.valueOf(value, hasHexPrefix ? 16 : 10);
                return true;
            }
            catch (NumberFormatException exception) {
                return false;
            }
        }

        @Override
        public IFilterExpression<CTraceEventWrapper> createExpression(String text2) {
            Pattern pattern = Pattern.compile(RULE_REGEX);
            Matcher matcher = pattern.matcher(text2);
            matcher.matches();
            boolean hasHexPrefix = matcher.group(3) != null;
            String register2 = matcher.group(1);
            FilterRelation predicate = FilterRelation.parse(matcher.group(2));
            String value = matcher.group(4);
            return new CRegisterFilterExpression(register2, predicate, Long.valueOf(value, hasHexPrefix ? 16 : 10));
        }
    }

    private static class PlainTextPredicateGenerator
    implements IPredicateGenerator<CTraceEventWrapper> {
        private PlainTextPredicateGenerator() {
        }

        @Override
        public boolean canParse(String text2) {
            return true;
        }

        @Override
        public IFilterExpression<CTraceEventWrapper> createExpression(String text2) {
            return new CTraceFilterExpression(text2.trim());
        }
    }

    private static class MemoryPredicateGenerator
    implements IPredicateGenerator<CTraceEventWrapper> {
        private static final String RULE_REGEX = "\\s*mem\\s*==\\s*([0-9a-fA-F]+)\\s*";

        private MemoryPredicateGenerator() {
        }

        @Override
        public boolean canParse(String text2) {
            return text2.matches(RULE_REGEX);
        }

        @Override
        public IFilterExpression<CTraceEventWrapper> createExpression(String text2) {
            String string2;
            Pattern pattern = Pattern.compile(RULE_REGEX);
            Matcher matcher = pattern.matcher(text2);
            matcher.matches();
            if (matcher.group(1).length() % 2 == 0) {
                string2 = matcher.group(1);
            } else {
                String string3 = String.valueOf(matcher.group(1));
                string2 = string3.length() != 0 ? "0".concat(string3) : new String("0");
            }
            String data = string2;
            return new CMemoryFilterExpression(data);
        }
    }
}

