/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists;

import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CTraceEventWrapper;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.ConcreteTree.IFilterExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.FilterRelation;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceRegister;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;

public class CRegisterFilterExpression
implements IFilterExpression<CTraceEventWrapper> {
    private final String m_register;
    private final FilterRelation m_predicate;
    private final long m_value;

    public CRegisterFilterExpression(String register2, FilterRelation predicate, long value) {
        this.m_register = register2;
        this.m_predicate = predicate;
        this.m_value = value;
    }

    private static boolean evaluateExpression(FilterRelation predicate, TraceRegister register2, long value) {
        switch (predicate) {
            case EQUAL_TO: {
                return register2.getValue().toLong() == value;
            }
            case GREATER_EQUAL_THAN: {
                return register2.getValue().toLong() >= value;
            }
            case GREATER_THAN: {
                return register2.getValue().toLong() > value;
            }
            case LESS_EQUAL_TO: {
                return register2.getValue().toLong() <= value;
            }
            case LESS_THAN: {
                return register2.getValue().toLong() < value;
            }
            case NOT_EQUAL_TO: {
                return register2.getValue().toLong() != value;
            }
        }
        throw new IllegalStateException("IE00264: Unknown predicate");
    }

    @Override
    public boolean evaluate(CTraceEventWrapper element) {
        ITraceEvent trace2 = element.unwrap();
        boolean returnValue = false;
        for (TraceRegister register2 : trace2.getRegisterValues()) {
            if (!"any".equalsIgnoreCase(this.m_register) && !register2.getName().equalsIgnoreCase(this.m_register)) continue;
            returnValue |= CRegisterFilterExpression.evaluateExpression(this.m_predicate, register2, this.m_value);
        }
        return returnValue;
    }
}

