/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Implementations.CTraceFunctions;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CFilteredTableModel;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListListener;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListProvider;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceManagerListener;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.IntComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class CEventListTableModel
extends CFilteredTableModel<TraceList> {
    private static final long serialVersionUID = -1005721402880762292L;
    private static final int NAME_COLUMN = 0;
    private static final int EVENT_COLUMN = 1;
    private static final int DESCRIPTION_COLUMN = 2;
    private static final String[] COLUMNS = new String[]{"Name", "Events", "Description"};
    private final ITraceListProvider m_traceProvider;
    private final InternalTraceListener m_listener = new InternalTraceListener();
    private List<TraceList> m_cachedValues = null;

    public CEventListTableModel(ITraceListProvider traceProvider) {
        Preconditions.checkNotNull(traceProvider, "IE01375: Event list manager can't be null");
        this.m_traceProvider = traceProvider;
        this.m_traceProvider.addListener(this.m_listener);
        if (traceProvider.isLoaded()) {
            for (TraceList traceList : traceProvider) {
                traceList.addListener(this.m_listener);
            }
        }
    }

    @Override
    public void delete() {
        this.m_traceProvider.removeListener(this.m_listener);
        if (this.m_traceProvider.isLoaded()) {
            for (TraceList traceList : this.m_traceProvider) {
                traceList.removeListener(this.m_listener);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNS[column];
    }

    @Override
    public int getRowCount() {
        return this.getTraces().size();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        ArrayList sorters = new ArrayList();
        sorters.add(new Pair<Integer, IntComparator>(1, new IntComparator()));
        return sorters;
    }

    public List<TraceList> getTraces() {
        List<TraceList> localCachedValues = this.m_cachedValues;
        if (localCachedValues == null) {
            IFilter<TraceList> filter;
            localCachedValues = this.m_traceProvider.isLoaded() ? ((filter = this.getFilter()) == null ? this.m_traceProvider.getTraces() : filter.get(this.m_traceProvider.getTraces())) : new ArrayList<TraceList>();
        }
        this.m_cachedValues = localCachedValues;
        return new ArrayList<TraceList>(localCachedValues);
    }

    @Override
    public Object getValueAt(int row, int col) {
        TraceList debugEvent = this.getTraces().get(row);
        switch (col) {
            case 0: {
                return debugEvent.getName();
            }
            case 1: {
                return debugEvent.getEventCount();
            }
            case 2: {
                return debugEvent.getDescription();
            }
        }
        throw new IllegalStateException("IE01119: Unkown column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 1;
    }

    @Override
    public void setFilter(IFilter<TraceList> filter) {
        this.m_cachedValues = null;
        super.setFilter(filter);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TraceList eventList = this.getTraces().get(row);
        if (col == 0) {
            CTraceFunctions.setTraceName(null, eventList, (String)value);
        } else if (col == 2) {
            CTraceFunctions.setTraceDescription(null, eventList, (String)value);
        }
    }

    private class InternalTraceListener
    implements ITraceManagerListener,
    ITraceListListener {
        private InternalTraceListener() {
        }

        @Override
        public void addedTrace(TraceList list) {
            CEventListTableModel.this.m_cachedValues = null;
            list.addListener(CEventListTableModel.this.m_listener);
            CEventListTableModel.this.fireTableDataChanged();
        }

        @Override
        public void changedDescription(TraceList traceList) {
            CEventListTableModel.this.m_cachedValues = null;
            CEventListTableModel.this.fireTableDataChanged();
        }

        @Override
        public void changedName(TraceList traceList) {
            CEventListTableModel.this.m_cachedValues = null;
            CEventListTableModel.this.fireTableDataChanged();
        }

        @Override
        public void eventAdded(TraceList trace2, ITraceEvent event) {
            CEventListTableModel.this.m_cachedValues = null;
            CEventListTableModel.this.fireTableDataChanged();
        }

        @Override
        public void loaded() {
            for (TraceList traceList : CEventListTableModel.this.m_traceProvider) {
                traceList.addListener(CEventListTableModel.this.m_listener);
            }
            CEventListTableModel.this.m_cachedValues = null;
            CEventListTableModel.this.fireTableDataChanged();
        }

        @Override
        public void removedTrace(TraceList list) {
            CEventListTableModel.this.m_cachedValues = null;
            list.removeListener(CEventListTableModel.this.m_listener);
            CEventListTableModel.this.fireTableDataChanged();
        }
    }
}

