/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Actions.CActionCombineTraces;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Actions.CActionDelete;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Actions.CActionDifferenceTraces;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Actions.CActionIntersectTraces;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Actions.CActionSelect;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Actions.CTagEventNodes;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventListTable;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTagsTree;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Implementations.CTaggingFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CSearchTableAction;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListProvider;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.tables.CTableSearcher;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public final class CEventListTableMenu
extends JPopupMenu {
    private static final long serialVersionUID = 945728009591780085L;

    public CEventListTableMenu(JFrame parent, CEventListTable table, ITraceListProvider traceProvider) {
        Preconditions.checkNotNull(parent, "IE01289: Parent argument can not be null");
        Preconditions.checkNotNull(table, "IE01290: Table argument can not be null");
        Preconditions.checkNotNull(traceProvider, "IE01291: Trace provider argument can not be null");
        int[] selectedRows = table.getConvertedSelectedRows();
        this.add(CActionProxy.proxy(new CActionDelete(parent, traceProvider, selectedRows)));
        this.addSeparator();
        this.add(CActionProxy.proxy(new CSearchTableAction(parent, table)));
        new CTableSearcher(parent, "Search", table, 0);
        if (selectedRows.length >= 2) {
            this.addCombineMenu(parent, traceProvider, selectedRows);
        }
    }

    public CEventListTableMenu(JFrame parent, CEventListTable table, ZyGraph graph, ITraceListProvider traceProvider, CTagsTree tree) {
        Preconditions.checkNotNull(parent, "IE01371: Parent argument can not be null");
        Preconditions.checkNotNull(table, "IE01372: Table argument can not be null");
        Preconditions.checkNotNull(graph, "IE01373: Graph argument can not be null");
        Preconditions.checkNotNull(traceProvider, "IE01374: Trace provider argument can not be null");
        int[] selectedRows = table.getConvertedSelectedRows();
        if (selectedRows.length == 1) {
            TraceList entry = traceProvider.getList(selectedRows[0]);
            this.add(CActionProxy.proxy(new CActionSelect(graph, entry)));
        }
        this.add(CActionProxy.proxy(new CActionDelete(parent, traceProvider, selectedRows)));
        this.addSeparator();
        this.add(CActionProxy.proxy(new CSearchTableAction(parent, table)));
        new CTableSearcher(parent, "Search", table, 0);
        if (selectedRows.length == 1) {
            try {
                CTag selectedTag = CTaggingFunctions.getSelectedTag(tree);
                this.addSeparator();
                TraceList entry = traceProvider.getList(selectedRows[0]);
                this.add(CActionProxy.proxy(new CTagEventNodes(parent, graph, entry, selectedTag)));
            }
            catch (MaybeNullException maybeNullException) {}
        } else {
            this.addCombineMenu(parent, traceProvider, selectedRows);
        }
    }

    private void addCombineMenu(JFrame parent, ITraceListProvider traceProvider, int[] selectedRows) {
        this.addSeparator();
        JMenu combineMenu = new JMenu("Combine Traces");
        List<TraceList> traces = this.getTraces(traceProvider, selectedRows);
        combineMenu.add(CActionProxy.proxy(new CActionCombineTraces(parent, traceProvider, traces)));
        combineMenu.add(CActionProxy.proxy(new CActionIntersectTraces(parent, traceProvider, traces)));
        if (traces.size() == 2) {
            combineMenu.addSeparator();
            combineMenu.add(CActionProxy.proxy(new CActionDifferenceTraces(parent, traceProvider, traces.get(0), traces.get(1))));
            combineMenu.add(CActionProxy.proxy(new CActionDifferenceTraces(parent, traceProvider, traces.get(1), traces.get(0))));
        }
        this.add(combineMenu);
    }

    private List<TraceList> getTraces(ITraceListProvider traceProvider, int[] indices) {
        ArrayList<TraceList> traces = new ArrayList<TraceList>();
        for (int index : indices) {
            traces.add(traceProvider.getList(index));
        }
        return traces;
    }
}

