/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.DebuggerSelectionPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.DebuggerSelectionPanel.CDebuggerWrapper;
import com.google.security.zynamics.binnavi.Help.CHelpFunctions;
import com.google.security.zynamics.binnavi.Help.IHelpInformation;
import com.google.security.zynamics.binnavi.Help.IHelpProvider;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.DebuggerProviderListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import java.net.URL;
import javax.swing.JComboBox;

public final class CDebuggerComboBox
extends JComboBox<CDebuggerWrapper>
implements IHelpProvider {
    private final DebuggerProviderListener m_internalDebuggerListener = new InternalDebuggerListener();
    private final BackEndDebuggerProvider m_provider;

    public CDebuggerComboBox(BackEndDebuggerProvider provider) {
        this.m_provider = Preconditions.checkNotNull(provider, "IE01363: Provider can not be null");
        for (IDebugger debugger : provider.getDebuggers()) {
            this.addItem(new CDebuggerWrapper(debugger));
        }
        provider.addListener(this.m_internalDebuggerListener);
    }

    public void dispose() {
        this.m_provider.removeListener(this.m_internalDebuggerListener);
    }

    @Override
    public IHelpInformation getHelpInformation() {
        return new IHelpInformation(){

            @Override
            public String getText() {
                return "Used to select the active debugger. This debugger is the one who receives input when you click buttons like Resume or set breakpoints.";
            }

            @Override
            public URL getUrl() {
                return CHelpFunctions.urlify("main_window.htm");
            }
        };
    }

    @Override
    public CDebuggerWrapper getSelectedItem() {
        return (CDebuggerWrapper)super.getSelectedItem();
    }

    private class InternalDebuggerListener
    implements DebuggerProviderListener {
        private InternalDebuggerListener() {
        }

        @Override
        public void debuggerAdded(BackEndDebuggerProvider provider, IDebugger debugger) {
            CDebuggerComboBox.this.addItem(new CDebuggerWrapper(debugger));
        }

        @Override
        public void debuggerRemoved(BackEndDebuggerProvider provider, IDebugger debugger) {
            for (int i2 = 0; i2 < CDebuggerComboBox.this.getItemCount(); ++i2) {
                if (((CDebuggerWrapper)CDebuggerComboBox.this.getItemAt(i2)).getObject() != debugger) continue;
                CDebuggerComboBox.this.removeItemAt(i2);
                return;
            }
        }
    }
}

