/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.CBreakpointTableHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.Condition;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import javax.swing.table.AbstractTableModel;

public final class CBreakpointTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1559835308928530054L;
    public static final int COLUMN_STATUS = 0;
    public static final int COLUMN_DEBUGGER = 1;
    public static final int COLUMN_UNRELOCATED_ADDRESS = 2;
    public static final int COLUMN_RELOCATED_ADDRESS = 3;
    public static final int COLUMN_MODULE_NAME = 4;
    public static final int COLUMN_CONDITION = 5;
    private static final int COLUMN_DESCRIPTION = 6;
    private final String[] columnNames = new String[]{"Status", "Debugger", "Unrelocated Address", "Relocated Address", "Module", "Condition", "Description"};
    private final BackEndDebuggerProvider m_debuggerProvider;

    public CBreakpointTableModel(BackEndDebuggerProvider debuggerProvider) {
        this.m_debuggerProvider = Preconditions.checkNotNull(debuggerProvider, "IE01339: Debugger provider can't be null");
    }

    private int calculateBreakpoints() {
        int breakpoints = 0;
        for (IDebugger debugger : this.m_debuggerProvider.getDebuggers()) {
            breakpoints += debugger.getBreakpointManager().getNumberOfBreakpoints(BreakpointType.REGULAR);
        }
        return breakpoints;
    }

    private IAddress getBreakpointAddress(int row) {
        Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(this.m_debuggerProvider, row);
        BreakpointManager manager = breakpoint.first().getBreakpointManager();
        int breakpointIndex = breakpoint.second();
        return manager.getBreakpoint(BreakpointType.REGULAR, breakpointIndex).getAddress().getAddress().getAddress();
    }

    private String getBreakpointCondition(int row) {
        int breakpointIndex;
        Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(this.m_debuggerProvider, row);
        BreakpointManager manager = breakpoint.first().getBreakpointManager();
        Condition condition = manager.getBreakpoint(BreakpointType.REGULAR, breakpointIndex = breakpoint.second().intValue()).getCondition();
        return condition == null ? "" : condition.toString();
    }

    private String getBreakpointDescription(int row) {
        Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(this.m_debuggerProvider, row);
        BreakpointManager manager = breakpoint.first().getBreakpointManager();
        int breakpointIndex = breakpoint.second();
        return manager.getBreakpoint(BreakpointType.REGULAR, breakpointIndex).getDescription();
    }

    private String getBreakpointModuleName(int row) {
        Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(this.m_debuggerProvider, row);
        BreakpointManager manager = breakpoint.first().getBreakpointManager();
        int breakpointIndex = breakpoint.second();
        return manager.getBreakpoint(BreakpointType.REGULAR, breakpointIndex).getAddress().getModule().getConfiguration().getName();
    }

    private BreakpointStatus getBreakpointStatus(int row) {
        Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(this.m_debuggerProvider, row);
        BreakpointManager manager = breakpoint.first().getBreakpointManager();
        int breakpointIndex = breakpoint.second();
        return manager.getBreakpointStatus(BreakpointType.REGULAR, breakpointIndex);
    }

    private String getDebuggerString(int row) {
        Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(this.m_debuggerProvider, row);
        for (IDebugger debugger : this.m_debuggerProvider) {
            if (debugger.getBreakpointManager() != breakpoint.first().getBreakpointManager()) continue;
            return debugger.getPrintableString();
        }
        return null;
    }

    private IAddress getRelocatedBreakpointAddress(int row) {
        Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(this.m_debuggerProvider, row);
        BreakpointManager manager = breakpoint.first().getBreakpointManager();
        int breakpointIndex = breakpoint.second();
        return breakpoint.first().fileToMemory(manager.getBreakpoint(BreakpointType.REGULAR, breakpointIndex).getAddress().getModule(), manager.getBreakpoint(BreakpointType.REGULAR, breakpointIndex).getAddress().getAddress()).getAddress();
    }

    private void updateCondition(BreakpointManager manager, int breakpointIndex, String formula) {
        manager.setBreakpointCondition(breakpointIndex, formula);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.calculateBreakpoints();
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.getBreakpointStatus(row);
            }
            case 1: {
                return this.getDebuggerString(row);
            }
            case 2: {
                return this.getBreakpointAddress(row);
            }
            case 3: {
                return this.getRelocatedBreakpointAddress(row);
            }
            case 4: {
                return this.getBreakpointModuleName(row);
            }
            case 5: {
                return this.getBreakpointCondition(row);
            }
            case 6: {
                return this.getBreakpointDescription(row);
            }
        }
        throw new IllegalArgumentException("IE01340: Unknown column");
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 5 || column == 6;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(this.m_debuggerProvider, row);
        BreakpointManager manager = breakpoint.first().getBreakpointManager();
        int breakpointIndex = breakpoint.second();
        switch (col) {
            case 5: {
                this.updateCondition(manager, breakpointIndex, value.toString());
                break;
            }
            case 6: {
                manager.getBreakpoint(BreakpointType.REGULAR, breakpointIndex).setDescription(value.toString());
            }
        }
        this.fireTableCellUpdated(row, col);
    }
}

