/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.BreakpointRemovalNotification;

import com.google.security.zynamics.binnavi.Gui.CIconInitializer;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class CBreakpointRemovalDialog
extends JDialog {
    private static final long serialVersionUID = -2869489487984715797L;

    private CBreakpointRemovalDialog(JFrame parent, Iterable<Pair<RelocatedAddress, Integer>> failedAddresses) {
        super(parent, "BinNavi", true);
        new CDialogEscaper(this);
        CIconInitializer.initializeWindowIcons(this);
        this.setLayout(new BorderLayout());
        JPanel upperPanel = new JPanel();
        upperPanel.add(new JLabel("The following breakpoints could not be removed from the target process:"));
        this.add((Component)upperPanel, "North");
        StringBuilder stringBuilder = new StringBuilder();
        for (Pair<RelocatedAddress, Integer> pair : failedAddresses) {
            stringBuilder.append(pair.first().getAddress().toHexString());
            stringBuilder.append('\n');
        }
        JTextArea textArea = new JTextArea(stringBuilder.toString());
        textArea.setEditable(false);
        textArea.setFont(GuiHelper.MONOSPACED_FONT);
        this.add(new JScrollPane(textArea));
        JPanel lowerPanel = new JPanel(new BorderLayout());
        JButton button = new JButton(new InternalButtonAction());
        lowerPanel.add((Component)button, "East");
        this.add((Component)lowerPanel, "South");
        this.setSize(500, 300);
    }

    public static void show(JFrame parent, Iterable<Pair<RelocatedAddress, Integer>> failedAddresses) {
        CBreakpointRemovalDialog dialog = new CBreakpointRemovalDialog(parent, failedAddresses);
        GuiHelper.centerChildToParent(parent, dialog, true);
        dialog.setVisible(true);
    }

    private final class InternalButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 3334899675534000200L;

        public InternalButtonAction() {
            super("OK");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CBreakpointRemovalDialog.this.dispose();
        }
    }
}

