/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Database;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CDatabaseConfiguration;
import com.google.security.zynamics.binnavi.Database.CDatabaseListenerAdapter;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseListener;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.Database.CDatabasePasswordField;
import com.google.security.zynamics.binnavi.Gui.Database.CStandardPanel;
import com.google.security.zynamics.binnavi.Gui.Database.DatabaseHostFieldHelp;
import com.google.security.zynamics.binnavi.Gui.Database.DatabaseNameFieldHelp;
import com.google.security.zynamics.binnavi.Gui.Database.Help.CAutoConnectHelp;
import com.google.security.zynamics.binnavi.Gui.Database.Help.CPasswordHelp;
import com.google.security.zynamics.binnavi.Gui.Database.Help.CSaveHelp;
import com.google.security.zynamics.binnavi.Gui.Database.Help.CSavePasswordHelp;
import com.google.security.zynamics.binnavi.Gui.Database.Help.CShowPasswordHelp;
import com.google.security.zynamics.binnavi.Gui.Database.Help.CTestHelp;
import com.google.security.zynamics.binnavi.Gui.Database.Help.DatabaseDescriptionFieldHelp;
import com.google.security.zynamics.binnavi.Gui.Database.Help.DatabaseIdentityFieldHelp;
import com.google.security.zynamics.binnavi.Gui.Database.Help.DatabaseUserFieldHelp;
import com.google.security.zynamics.binnavi.Gui.Database.IDatabaseSettingsPanelListener;
import com.google.security.zynamics.binnavi.Gui.Database.actions.CActionShowPassword;
import com.google.security.zynamics.binnavi.Gui.Database.actions.CSaveDatabaseAction;
import com.google.security.zynamics.binnavi.Gui.Database.actions.CTestDatabaseConnection;
import com.google.security.zynamics.binnavi.Gui.Database.implementations.CDatabaseConnector;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CDatabaseConnectionFunctions;
import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressManager;
import com.google.security.zynamics.binnavi.Gui.Progress.IProgressOperation;
import com.google.security.zynamics.binnavi.Gui.SaveFields.CSaveCheckbox;
import com.google.security.zynamics.binnavi.Gui.SaveFields.CSaveField;
import com.google.security.zynamics.binnavi.Gui.SaveFields.CSavePasswordField;
import com.google.security.zynamics.binnavi.Help.CHelpButton;
import com.google.security.zynamics.binnavi.Help.CHelpCheckbox;
import com.google.security.zynamics.binnavi.Help.CHelpLabel;
import com.google.security.zynamics.binnavi.Help.CHelpSaveCheckbox;
import com.google.security.zynamics.binnavi.Help.CHelpSaveField;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class CDatabaseSettingsPanel
extends JPanel {
    private final CHelpSaveField databaseDescriptionField = new CHelpSaveField(new DatabaseDescriptionFieldHelp());
    private final CSaveField databaseHostField = new CHelpSaveField(new DatabaseHostFieldHelp());
    private final CSaveField databaseNameField = new CHelpSaveField(new DatabaseNameFieldHelp());
    private final CSaveField databaseUserField = new CHelpSaveField(new DatabaseUserFieldHelp());
    private final CSaveField databaseIdentityField = new CHelpSaveField(new DatabaseIdentityFieldHelp());
    private final CSavePasswordField passwordField = new CDatabasePasswordField();
    private final JCheckBox showPasswordBox = new CHelpCheckbox(new CActionShowPassword(this.passwordField), new CShowPasswordHelp());
    private final CSaveCheckbox savePasswordBox = new CHelpSaveCheckbox("Save Password to configuration file", new CSavePasswordHelp());
    private final CSaveCheckbox autoConnectBox = new CHelpSaveCheckbox("Connect automatically", new CAutoConnectHelp());
    private final JButton testButton = new CHelpButton(CActionProxy.proxy(new CTestDatabaseConnection(this)), new CTestHelp());
    private final JButton saveButton = new CHelpButton(CActionProxy.proxy(new CSaveDatabaseAction(this)), new CSaveHelp());
    private final IDatabase database;
    private final InternalDatabaseListener databaseListener = new InternalDatabaseListener();
    private final JLabel saveLabel;
    private final ListenerProvider<IDatabaseSettingsPanelListener> listeners = new ListenerProvider();

    public CDatabaseSettingsPanel(IDatabase database) {
        super(new BorderLayout());
        this.database = Preconditions.checkNotNull(database, "IE01317: Database argument can't be null");
        this.database.addListener(this.databaseListener);
        JPanel lowerPanel = new JPanel(new BorderLayout());
        JPanel outerDescriptionPanel = new JPanel(new BorderLayout(5, 5));
        outerDescriptionPanel.setBorder(new TitledBorder("Database"));
        JPanel innerDescriptionPanel = new JPanel(new BorderLayout());
        innerDescriptionPanel.setBorder(new EmptyBorder(0, 0, 8, 0));
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        CHelpLabel label = new CHelpLabel("Description:", new DatabaseDescriptionFieldHelp());
        int PREFERRED_LABEL_WIDTH = 110;
        int PREFERRED_LABEL_HEIGHT = 25;
        label.setPreferredSize(new Dimension(110, 25));
        innerDescriptionPanel.add((Component)label, "West");
        innerDescriptionPanel.add((Component)this.databaseDescriptionField, "Center");
        outerDescriptionPanel.add((Component)innerDescriptionPanel, "Center");
        JPanel pDB4 = new JPanel(new BorderLayout());
        pDB4.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel pDB3 = new JPanel(new BorderLayout());
        pDB3.setBorder(new EmptyBorder(5, 0, 5, 0));
        JPanel pDB2 = new JPanel(new BorderLayout());
        pDB2.setBorder(new EmptyBorder(0, 0, 5, 0));
        JPanel pDB = new JPanel(new GridLayout(4, 1, 5, 5));
        pDB.setBorder(new EmptyBorder(0, 0, 5, 0));
        JPanel borderHelperPanel = new JPanel(new BorderLayout());
        borderHelperPanel.setBorder(new TitledBorder("Connection"));
        pDB.add(new CStandardPanel("DB host:", new DatabaseHostFieldHelp(), this.databaseHostField));
        pDB.add(new CStandardPanel("DB name:", new DatabaseNameFieldHelp(), this.databaseNameField));
        pDB.add(new CStandardPanel("DB user:", new DatabaseUserFieldHelp(), this.databaseUserField));
        pDB.add(new CStandardPanel("DB password:", new CPasswordHelp(), this.passwordField));
        pDB.add(new CStandardPanel("", null, this.showPasswordBox));
        borderHelperPanel.add((Component)pDB, "Center");
        pDB2.add((Component)borderHelperPanel, "Center");
        JPanel mainPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        JPanel p5_h = new JPanel(new BorderLayout());
        JPanel p5_h2 = new JPanel(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        JPanel savePasswordPanel = new JPanel(new BorderLayout());
        savePasswordPanel.add((Component)this.savePasswordBox, "West");
        mainPanel.add(savePasswordPanel);
        JPanel autoConnectPanel = new JPanel(new BorderLayout());
        autoConnectPanel.add((Component)this.autoConnectBox, "West");
        mainPanel.add(autoConnectPanel);
        p5_h.setBorder(new TitledBorder(new TitledBorder("Behavior")));
        p5_h.add((Component)mainPanel, "Center");
        p5_h2.setBorder(new EmptyBorder(0, 0, 5, 0));
        p5_h2.add((Component)p5_h, "Center");
        pDB3.add((Component)pDB2, "North");
        JPanel identityPanel = new JPanel(new BorderLayout());
        JPanel identitySubPanel = new JPanel(new BorderLayout());
        identitySubPanel.setBorder(new TitledBorder(null, "Identity", 4, 2, null, null));
        identitySubPanel.add(new CStandardPanel("Identity:", new DatabaseIdentityFieldHelp(), this.databaseIdentityField));
        identityPanel.add((Component)identitySubPanel, "Center");
        pDB3.add((Component)identityPanel, "Center");
        pDB3.add((Component)p5_h2, "South");
        this.savePasswordBox.addActionListener(new InternalActionListener());
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3, 5, 5));
        buttonPanel.setBorder(new EmptyBorder(0, 2, 0, 2));
        buttonPanel.add(this.testButton);
        buttonPanel.add(this.saveButton);
        JPanel savePanel = new JPanel(new FlowLayout());
        this.saveLabel = new JLabel("Please hit the Save button to use the current database connection from BinNavi");
        this.saveLabel.setBorder(new CompoundBorder(new LineBorder(Color.RED, 2), new EmptyBorder(5, 5, 5, 5)));
        this.saveLabel.setForeground(Color.RED);
        savePanel.add(this.saveLabel);
        centerPanel.add((Component)savePanel, "North");
        centerPanel.add((Component)buttonPanel, "Center");
        pDB4.add((Component)pDB3, "North");
        pDB4.add((Component)centerPanel, "Center");
        lowerPanel.add((Component)outerDescriptionPanel, "North");
        lowerPanel.add((Component)pDB4, "Center");
        this.add(lowerPanel);
        this.databaseDescriptionField.setText(this.database.getConfiguration().getDescription());
        this.databaseHostField.setText(this.database.getConfiguration().getHost());
        this.databaseNameField.setText(this.database.getConfiguration().getName());
        this.databaseUserField.setText(this.database.getConfiguration().getUser());
        this.databaseIdentityField.setText(this.database.getConfiguration().getIdentity());
        this.passwordField.setText(this.database.getConfiguration().getPassword());
        this.savePasswordBox.setSelected(this.database.getConfiguration().isSavePassword());
        this.autoConnectBox.setSelected(this.database.getConfiguration().isAutoConnect());
        this.updateSaveButton();
        UpdateListener updateListener = new UpdateListener();
        this.databaseDescriptionField.getDocument().addDocumentListener(updateListener);
        this.databaseHostField.getDocument().addDocumentListener(updateListener);
        this.databaseNameField.getDocument().addDocumentListener(updateListener);
        this.databaseUserField.getDocument().addDocumentListener(updateListener);
        this.databaseIdentityField.getDocument().addDocumentListener(updateListener);
        this.passwordField.getDocument().addDocumentListener(updateListener);
        this.savePasswordBox.addItemListener(updateListener);
        this.autoConnectBox.addItemListener(updateListener);
        this.setupHotkeys();
    }

    private void setupHotkeys() {
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(HotKeys.DATABASE_SETTINGS_TEST_CONNECTION_KEY.getKeyStroke(), "TEST_CONNECTION");
        actionMap.put("TEST_CONNECTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (CDatabaseSettingsPanel.this.testButton.isEnabled()) {
                    CDatabaseSettingsPanel.this.testConnection();
                }
            }
        });
        inputMap.put(HotKeys.DATABASE_SETTINGS_SAVE_CONNECTION_KEY.getKeyStroke(), "SAVE_CONNECTION");
        actionMap.put("SAVE_CONNECTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CDatabaseSettingsPanel.this.saveConnection();
            }
        });
    }

    private void updateGui() {
        this.autoConnectBox.setEnabled(this.savePasswordBox.isSelected());
        if (!this.savePasswordBox.isSelected()) {
            this.autoConnectBox.setSelected(false);
        }
    }

    private void updateSaveButton() {
        boolean userChanged = !this.databaseUserField.getText().equals(this.database.getConfiguration().getUser());
        boolean descriptionChanged = !this.databaseDescriptionField.getText().equals(this.database.getConfiguration().getDescription());
        boolean hostChanged = !this.databaseHostField.getText().equals(this.database.getConfiguration().getHost());
        boolean nameChanged = !this.databaseNameField.getText().equals(this.database.getConfiguration().getName());
        boolean passwordChanged = !new String(this.passwordField.getPassword()).equals(this.database.getConfiguration().getPassword());
        boolean savePasswordChanged = this.savePasswordBox.isSelected() != this.database.getConfiguration().isSavePassword();
        boolean autoConnectChanged = this.autoConnectBox.isSelected() != this.database.getConfiguration().isAutoConnect();
        boolean identityChanged = !this.databaseIdentityField.getText().equals(this.database.getConfiguration().getIdentity());
        this.databaseDescriptionField.setModified(descriptionChanged);
        this.databaseHostField.setModified(hostChanged);
        this.databaseNameField.setModified(nameChanged);
        this.databaseUserField.setModified(userChanged);
        this.passwordField.setModified(passwordChanged);
        this.savePasswordBox.setModified(savePasswordChanged);
        this.autoConnectBox.setModified(autoConnectChanged);
        this.databaseIdentityField.setModified(identityChanged);
        this.saveButton.setEnabled(descriptionChanged || hostChanged || nameChanged || userChanged || passwordChanged || savePasswordChanged || autoConnectChanged || identityChanged);
        this.saveLabel.setVisible(this.saveButton.isEnabled());
        boolean connectionChanged = hostChanged || nameChanged || userChanged || passwordChanged;
        for (IDatabaseSettingsPanelListener listener : this.listeners) {
            try {
                listener.changedConnectionSettings(this, connectionChanged);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void addListener(IDatabaseSettingsPanelListener listener) {
        this.listeners.addListener(listener);
    }

    public void delete() {
        this.database.removeListener(this.databaseListener);
    }

    public void removeListener(IDatabaseSettingsPanelListener listener) {
        this.listeners.removeListener(listener);
    }

    public void saveConnection() {
        boolean connectionChanged = !this.database.getConfiguration().getPassword().equals(new String(this.passwordField.getPassword())) || !this.database.getConfiguration().getHost().equals(this.databaseHostField.getText()) || !this.database.getConfiguration().getName().equals(this.databaseNameField.getText()) || !this.database.getConfiguration().getUser().equals(this.databaseUserField.getText());
        this.database.getConfiguration().setAutoConnect(this.autoConnectBox.isSelected());
        this.database.getConfiguration().setDescription(this.databaseDescriptionField.getText());
        this.database.getConfiguration().setPassword(new String(this.passwordField.getPassword()));
        this.database.getConfiguration().setSavePassword(this.savePasswordBox.isSelected());
        this.database.getConfiguration().setHost(this.databaseHostField.getText());
        this.database.getConfiguration().setName(this.databaseNameField.getText());
        this.database.getConfiguration().setUser(this.databaseUserField.getText());
        this.database.getConfiguration().setIdentity(this.databaseIdentityField.getText());
        if (this.database.isConnected() && connectionChanged && CMessageBox.showYesNoQuestion(SwingUtilities.getWindowAncestor(this), "To adopt the changes you have to re-connect to the database. Do you want to reconnect now?") == 0) {
            if (this.database.close()) {
                CDatabaseConnectionFunctions.openDatabase(SwingUtilities.getWindowAncestor(this), this.database);
            } else {
                CMessageBox.showInformation(SwingUtilities.getWindowAncestor(this), "Could not close the selected database because views or other elements from the database are still open.");
            }
        }
        ConfigManager.instance().saveSettings((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.autoConnectBox.setEnabled(enabled);
        this.databaseDescriptionField.setEnabled(enabled);
        this.passwordField.setEnabled(enabled);
        this.showPasswordBox.setEnabled(enabled);
        this.saveButton.setEnabled(enabled);
        this.testButton.setEnabled(enabled);
        this.savePasswordBox.setEnabled(enabled);
        this.databaseHostField.setEnabled(enabled);
        this.databaseNameField.setEnabled(enabled);
        this.databaseUserField.setEnabled(enabled);
        this.databaseIdentityField.setEnabled(enabled);
    }

    public void testConnection() {
        this.testButton.setEnabled(false);
        if (this.databaseIdentityField.getText().isEmpty() || this.databaseIdentityField.getText() == null) {
            CMessageBox.showInformation(SwingUtilities.getWindowAncestor(this), "Could not test the connection to the database because the identity name is not set.");
            this.testButton.setEnabled(true);
            return;
        }
        if (this.databaseUserField.getText().isEmpty() || this.databaseUserField.getText() == null) {
            CMessageBox.showInformation(SwingUtilities.getWindowAncestor(this), "Could not test the connection to the database because the user name is not set.");
            this.testButton.setEnabled(true);
            return;
        }
        if (new String(this.passwordField.getPassword()).isEmpty()) {
            CMessageBox.showInformation(SwingUtilities.getWindowAncestor(this), "Could not test the connection to the database because the password is not set.");
            this.testButton.setEnabled(true);
            return;
        }
        new Thread(){

            @Override
            public void run() {
                final CProgressPanel panel = new CProgressPanel("Testing database connection", true, false, false);
                IProgressOperation operation = new IProgressOperation(){

                    @Override
                    public String getDescription() {
                        return "Testing DB Connection";
                    }

                    @Override
                    public CProgressPanel getProgressPanel() {
                        return panel;
                    }
                };
                CGlobalProgressManager.instance().add(operation);
                panel.start();
                CDatabaseConfiguration configuration = new CDatabaseConfiguration(CDatabaseSettingsPanel.this.database, new ListenerProvider<IDatabaseListener>(), "CONNECTION TEST", CDatabaseSettingsPanel.this.database.getConfiguration().getDriver(), CDatabaseSettingsPanel.this.databaseHostField.getText(), CDatabaseSettingsPanel.this.databaseNameField.getText(), CDatabaseSettingsPanel.this.databaseUserField.getText(), new String(CDatabaseSettingsPanel.this.passwordField.getPassword()), CDatabaseSettingsPanel.this.databaseIdentityField.getText(), false, false);
                CDatabaseConnector.testConnection(SwingUtilities.getWindowAncestor(CDatabaseSettingsPanel.this), configuration);
                CGlobalProgressManager.instance().remove(operation);
                CDatabaseSettingsPanel.this.testButton.setEnabled(true);
            }
        }.start();
    }

    private class UpdateListener
    implements DocumentListener,
    ItemListener {
        private UpdateListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            CDatabaseSettingsPanel.this.updateSaveButton();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            CDatabaseSettingsPanel.this.updateSaveButton();
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            CDatabaseSettingsPanel.this.updateSaveButton();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            CDatabaseSettingsPanel.this.updateSaveButton();
        }
    }

    private class InternalDatabaseListener
    extends CDatabaseListenerAdapter {
        private InternalDatabaseListener() {
        }

        @Override
        public void changedAutoConnect(IDatabase database, boolean autoConnect) {
            CDatabaseSettingsPanel.this.autoConnectBox.setSelected(autoConnect);
            CDatabaseSettingsPanel.this.updateSaveButton();
        }

        @Override
        public void changedDescription(IDatabase database, String description) {
            CDatabaseSettingsPanel.this.databaseDescriptionField.setText(description);
            CDatabaseSettingsPanel.this.updateSaveButton();
        }

        @Override
        public void changedDriver(IDatabase database, String driver) {
        }

        @Override
        public void changedHost(IDatabase database, String host) {
            CDatabaseSettingsPanel.this.databaseHostField.setText(database.getConfiguration().getHost());
            CDatabaseSettingsPanel.this.updateSaveButton();
        }

        @Override
        public void changedIdentity(IDatabase database, String identity) {
            CDatabaseSettingsPanel.this.databaseIdentityField.setText(identity);
            CDatabaseSettingsPanel.this.updateSaveButton();
        }

        @Override
        public void changedName(IDatabase database, String name) {
            CDatabaseSettingsPanel.this.databaseNameField.setText(database.getConfiguration().getName());
            CDatabaseSettingsPanel.this.updateSaveButton();
        }

        @Override
        public void changedPassword(IDatabase database, String password) {
            CDatabaseSettingsPanel.this.passwordField.setText(password);
            CDatabaseSettingsPanel.this.updateSaveButton();
        }

        @Override
        public void changedSavePassword(IDatabase database, boolean savePassword) {
            CDatabaseSettingsPanel.this.savePasswordBox.setSelected(savePassword);
            CDatabaseSettingsPanel.this.updateSaveButton();
        }

        @Override
        public void changedUser(IDatabase database, String user2) {
            CDatabaseSettingsPanel.this.databaseUserField.setText(user2);
            CDatabaseSettingsPanel.this.updateSaveButton();
        }
    }

    private class InternalActionListener
    implements ActionListener {
        private InternalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CDatabaseSettingsPanel.this.updateGui();
        }
    }
}

