/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Implementations;

import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.CConditionBox;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.CCriteriumWrapper;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCriteriumTree;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCriteriumTreeNode;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.ICriteriumTreeNode;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.JCriteriumTree;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.JCriteriumTreeNode;
import javax.swing.tree.TreePath;

public final class CCriteriumFunctions {
    private CCriteriumFunctions() {
    }

    private static void disposeTree(CCriteriumTreeNode root) {
        root.getCriterium().dispose();
        for (CCriteriumTreeNode child : root.getChildren()) {
            CCriteriumFunctions.disposeTree(child);
        }
    }

    public static void appendCriterium(CCriteriumTree tree, CCriteriumTreeNode parent, ICriterium criterium) {
        tree.appendNode(parent, new CCriteriumTreeNode(criterium));
    }

    public static void appendCriterium(JCriteriumTree jtree, CCriteriumTree ctree, CConditionBox conditionBox) {
        TreePath path = jtree.getSelectionPath();
        if (path != null) {
            ICriterium criterium;
            JCriteriumTreeNode criteriumTreeNode = (JCriteriumTreeNode)path.getLastPathComponent();
            CCriteriumTreeNode parent = CCriteriumFunctions.findNode(ctree.getRoot(), criteriumTreeNode.getCriterium());
            CCriteriumWrapper selectedItem = (CCriteriumWrapper)conditionBox.getSelectedItem();
            if (selectedItem != null && (criterium = ((ICriteriumCreator)selectedItem.getObject()).createCriterium()) != null) {
                CCriteriumFunctions.appendCriterium(ctree, parent, criterium);
            }
        }
    }

    public static CCriteriumTreeNode findNode(CCriteriumTreeNode node, ICriterium criterium) {
        if (node.getCriterium() == criterium) {
            return node;
        }
        for (CCriteriumTreeNode child : node.getChildren()) {
            CCriteriumTreeNode childNode = CCriteriumFunctions.findNode(child, criterium);
            if (childNode == null) continue;
            return childNode;
        }
        return null;
    }

    public static void insertCriterium(CCriteriumTree tree, CCriteriumTreeNode parent, ICriterium criterium) {
        tree.insertNode(parent, new CCriteriumTreeNode(criterium));
    }

    public static void remove(CCriteriumTree tree, ICriteriumTreeNode node) {
        node.getCriterium().dispose();
        tree.remove(node);
    }

    public static void removeAll(CCriteriumTree tree) {
        CCriteriumFunctions.disposeTree(tree.getRoot());
        tree.clear();
    }
}

